/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.RuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.osgi.framework.Bundle;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.AbstractPackageAdder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlePackageAdder
extends AbstractPackageAdder
implements IPackageAdder {
    private static Logger logger = Logger.getLogger(BundlePackageAdder.class.getName());

    public BundlePackageAdder(Bundle bundle, Map<String, Object> globals) {
        super(bundle, globals);
    }

    public BundlePackageAdder(Bundle bundle, Map<String, Object> globals, String workingMemoryName) {
        super(bundle, globals, workingMemoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackage(PackageBuilder builder, RuleBase ruleBase) throws Exception {
        Package pack;
        Enumeration drlXmlPaths;
        Enumeration drlPaths = this.bundle.findEntries("/", "*.drl", true);
        if (drlPaths != null) {
            while (drlPaths.hasMoreElements()) {
                URL drlPath = (URL)drlPaths.nextElement();
                String externalForm = drlPath.toExternalForm();
                URL dslPath = this.bundle.getEntry(externalForm.substring(0, externalForm.length() - 4) + ".dsl");
                InputStreamReader fileReader = new InputStreamReader(drlPath.openStream());
                if (dslPath == null) {
                    try {
                        builder.addPackageFromDrl((Reader)fileReader);
                        logger.log(Level.INFO, drlPath.getPath() + " loaded");
                        continue;
                    }
                    finally {
                        ((Reader)fileReader).close();
                        continue;
                    }
                }
                InputStreamReader dslReader = new InputStreamReader(dslPath.openStream());
                try {
                    builder.addPackageFromDrl((Reader)fileReader, (Reader)dslReader);
                    logger.log(Level.INFO, drlPath.getPath() + " and " + dslPath.getPath() + " loaded");
                }
                finally {
                    ((Reader)fileReader).close();
                    ((Reader)dslReader).close();
                }
            }
        }
        if ((drlXmlPaths = this.bundle.findEntries("/", "*.drl.xml", true)) != null) {
            while (drlXmlPaths.hasMoreElements()) {
                URL drlXmlPath = (URL)drlXmlPaths.nextElement();
                InputStreamReader fileReader = new InputStreamReader(drlXmlPath.openStream());
                try {
                    builder.addPackageFromXml((Reader)fileReader);
                    logger.log(Level.INFO, drlXmlPath.getPath() + " loaded");
                }
                finally {
                    ((Reader)fileReader).close();
                }
            }
        }
        if ((pack = builder.getPackage()) != null) {
            pack.checkValidity();
            Rule[] rules = pack.getRules();
            if (rules.length != 0) {
                ruleBase.addPackage(pack);
            }
        }
    }
}

