/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.RuleBase;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.osgi.framework.Bundle;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.AbstractPackageAdder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrlPackageAdder
extends AbstractPackageAdder
implements IPackageAdder {
    private static Logger logger = Logger.getLogger(DrlPackageAdder.class.getName());
    private final String packageName;
    private final String drlFile;

    public DrlPackageAdder(Bundle bundle, Map<String, Object> globals, String packageName, String drlFile) {
        super(bundle, globals);
        this.packageName = packageName;
        this.drlFile = drlFile;
    }

    public DrlPackageAdder(Bundle bundle, Map<String, Object> globals, String workingMemoryName, String packageName, String drlFile) {
        super(bundle, globals, workingMemoryName);
        this.packageName = packageName;
        this.drlFile = drlFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackage(PackageBuilder builder, RuleBase ruleBase) throws Exception {
        StringReader drlFileReader = new StringReader(this.drlFile);
        try {
            builder.addPackageFromDrl((Reader)drlFileReader);
            logger.log(Level.INFO, "Drl file loaded");
        }
        finally {
            ((Reader)drlFileReader).close();
        }
        Package pack = builder.getPackage();
        if (pack != null) {
            pack.checkValidity();
            Rule[] rules = pack.getRules();
            if (rules.length != 0) {
                ruleBase.addPackage(pack);
            }
        }
    }
}

