/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.PackageBuilder;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.DrlPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.MultiBundleClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDroolsWorkingMemory
extends AbstractDroolsWorkingMemory
implements IOSGiDroolsWorkingMemory {
    private static Logger logger = Logger.getLogger(OSGiDroolsWorkingMemory.class.getName());
    private final MultiBundleClassLoader multiBundleClassLoader;
    protected final Map<ServiceReference, IPackageAdder> packageAdders;

    public OSGiDroolsWorkingMemory(ClassLoader externalLoader, Map<ServiceReference, IPackageAdder> packageAdders) {
        super(externalLoader, logger);
        this.packageAdders = packageAdders;
        this.multiBundleClassLoader = new MultiBundleClassLoader(this.getClass().getClassLoader());
    }

    @Override
    public void start() throws Exception {
        if (!this.packageAdders.isEmpty()) {
            this.addPackages(this.packageAdders.values());
        } else {
            this.state = DroolsWorkingMemoryState.IDLE;
        }
    }

    @Override
    public void addPackage(ServiceReference serviceReference, IPackageAdder packageAdder) throws Exception {
        if (this.packageAdders.put(serviceReference, packageAdder) == null && this.state != DroolsWorkingMemoryState.STOPPED) {
            this.addPackages(Collections.singletonList(packageAdder));
        }
    }

    @Override
    public void removePackage(ServiceReference serviceReference) throws Exception {
        IPackageAdder packageAdder = this.packageAdders.get(serviceReference);
        if (packageAdder != null) {
            this.packageAdders.remove(serviceReference);
            this.multiBundleClassLoader.removeBundleClassLoader(packageAdder.getBundle());
            if (packageAdder instanceof DrlPackageAdder) {
                this.ruleBase.removePackage(((DrlPackageAdder)packageAdder).getPackageName());
            }
            if (this.packageAdders.size() < 1) {
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
            } else {
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
                this.ruleBase = null;
                this.workingMemory = null;
                if (this.packageAdders.size() > 0) {
                    this.addPackages(this.packageAdders.values());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackages(Collection<IPackageAdder> packageAdders) throws Exception {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this.ruleBase == null) {
                this.ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration((ClassLoader)this.multiBundleClassLoader));
            }
            for (IPackageAdder packageAdder : packageAdders) {
                Map<String, Object> globals;
                PackageBuilder packageBuilder = this.getPackageBuilder();
                packageAdder.addPackage(packageBuilder, this.ruleBase);
                this.multiBundleClassLoader.addBundleClassLoader(packageAdder.getBundle());
                if (this.workingMemory == null || (globals = packageAdder.getGlobals()) == null) continue;
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    this.workingMemory.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            if (this.workingMemory == null) {
                this.createWorkingMemory();
                for (IPackageAdder packageAdder : packageAdders) {
                    Map<String, Object> globals = packageAdder.getGlobals();
                    if (globals == null) continue;
                    for (Map.Entry<String, Object> entry : globals.entrySet()) {
                        this.workingMemory.setGlobal(entry.getKey(), entry.getValue());
                    }
                }
            }
            this.startRuleExecutor();
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

