/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemory;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.OSGiDroolsWorkingMemory;

public class OSGiDroolsWorkingMemoryPool
extends AbstractDroolsWorkingMemoryPool
implements IOSGiDroolsWorkingMemoryPool {
    private static Logger logger = Logger.getLogger(OSGiDroolsWorkingMemoryPool.class.getName());
    private ClassLoader defaultLoader;

    public OSGiDroolsWorkingMemoryPool(ClassLoader defaultLoader) {
        this.defaultLoader = defaultLoader;
    }

    public IDroolsWorkingMemory getOrCreate(String workingMemoryName) throws Exception {
        IDroolsWorkingMemory result = this.get(workingMemoryName);
        if (result == null) {
            logger.log(Level.INFO, "There is no WorkingMemory named \"" + workingMemoryName + "\" in the pool. Creating it...");
            result = new OSGiDroolsWorkingMemory(this.defaultLoader, new HashMap<ServiceReference, IPackageAdder>());
            if (Boolean.getBoolean("jonas.developer")) {
                File dumpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "drools_dump");
                boolean exists = dumpDir.exists();
                if (!exists) {
                    exists = dumpDir.mkdir();
                }
                if (exists && dumpDir.isDirectory()) {
                    ((AbstractDroolsWorkingMemory)result).setDumpDir(dumpDir);
                }
            }
            this.add(workingMemoryName, result);
        }
        return result;
    }
}

