/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;

public class PackageAdderListener
implements ServiceListener {
    private static Logger logger = Logger.getLogger(PackageAdderListener.class.getName());
    private final IOSGiDroolsWorkingMemoryPool droolsWorkingMemoryPool;
    private final BundleContext context;

    public PackageAdderListener(BundleContext context, IOSGiDroolsWorkingMemoryPool droolsWorkingMemoryPool) {
        this.context = context;
        this.droolsWorkingMemoryPool = droolsWorkingMemoryPool;
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference ref = event.getServiceReference();
        IPackageAdder packageAdder = (IPackageAdder)this.context.getService(ref);
        String workingMemoryName = packageAdder.getWorkingMemoryName();
        switch (event.getType()) {
            case 1: {
                try {
                    IOSGiDroolsWorkingMemory theWorkingMemory;
                    logger.log(Level.INFO, "New rules package for theWorkingMemory \"" + workingMemoryName + "\"");
                    try {
                        theWorkingMemory = (IOSGiDroolsWorkingMemory)((Object)((IDroolsWorkingMemoryPool)((Object)this.droolsWorkingMemoryPool)).getOrCreate(workingMemoryName));
                    }
                    catch (Exception e) {
                        logger.log(Level.INFO, "Could not get or create a working memorynamed \"" + workingMemoryName + "\": " + e);
                        return;
                    }
                    theWorkingMemory.addPackage(ref, packageAdder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 4: {
                try {
                    logger.log(Level.INFO, "Remove a rule package from the WorkingMemory \"" + workingMemoryName + "\"");
                    IOSGiDroolsWorkingMemory theWorkingMemory = (IOSGiDroolsWorkingMemory)((Object)((IDroolsWorkingMemoryPool)((Object)this.droolsWorkingMemoryPool)).get(workingMemoryName));
                    theWorkingMemory.removePackage(ref);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

