/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.endpoints;

import java.util.Date;
import java.util.LinkedList;
import java.util.TreeMap;
import org.ow2.jasmine.event.messages.JasmineEvent;

public class MBeanCmdDispatcher {
    private static final String nonProbeFields = ";date;time;server;domain;mbean;name;sname;";

    private static int getVersion(String header, String format) throws UnsupportedOperationException {
        try {
            if (header.indexOf(format) == 0) {
                return Integer.parseInt(header.substring(format.length()));
            }
            if (header.indexOf("time;date;server;domain;mbean;") == 0) {
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Header not recognized: " + header);
    }

    public JasmineEvent receivedMBeanCmdMessage(String msg) {
        String[] message = msg.split("\n");
        int version = MBeanCmdDispatcher.getVersion(message[0], "mbeancmd_values_v");
        if (version < 0 || version > 1) {
            throw new UnsupportedOperationException("Unknown MBeanCmd message version: " + version);
        }
        String[] msgHeader = message[1].split(";");
        String[] msgBody = message[2].split(";");
        TreeMap<String, Integer> header = new TreeMap<String, Integer>();
        LinkedList<String> probes = new LinkedList<String>();
        for (int i = 0; i < msgHeader.length; ++i) {
            if (msgHeader[i].length() <= 0) continue;
            header.put(msgHeader[i], i);
            if (nonProbeFields.contains(";" + msgHeader[i] + ";")) continue;
            probes.add(msgHeader[i]);
        }
        JasmineEvent event = new JasmineEvent();
        Date timestamp = new Date(Long.parseLong(msgBody[(Integer)header.get("time")]));
        event.setDomain(msgBody[(Integer)header.get("domain")]);
        event.setServer(msgBody[(Integer)header.get("server")]);
        String mbean = msgBody[(Integer)header.get("mbean")] + ":";
        String sname = msgBody[(Integer)header.get("sname")];
        for (String s : probes) {
            event.addEvent("mbeancmd", mbean + s, msgBody[(Integer)header.get(s)], timestamp, sname);
        }
        return event;
    }

    public JasmineEvent receivedMBeanCmdMessage(byte[] msg) {
        return this.receivedMBeanCmdMessage(new String(msg));
    }
}

