/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.endpoints;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.umo.lifecycle.Startable;
import org.mule.umo.lifecycle.Stoppable;
import org.ow2.jasmine.monitoring.eventswitch.manager.EventSwitchManager;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;

public class MBeanCmdWrapper
implements Startable,
Stoppable {
    private String configuration = null;
    private long delay = 0L;
    private EventSwitchManager manager = null;

    public static synchronized String[] parseCommandLine(String line) {
        int lastQuoteEnd = 0;
        LinkedList<String> args = new LinkedList<String>();
        Pattern space = Pattern.compile("\\ |\\\t");
        Matcher matcher = Pattern.compile("\\\"[^\\\"]*\\\"").matcher(line);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            for (String c : space.split(line.substring(lastQuoteEnd, start))) {
                if (c.length() <= 0) continue;
                args.add(c);
            }
            args.add(line.substring(start + 1, end - 1));
            lastQuoteEnd = end;
        }
        for (String c : space.split(line.substring(lastQuoteEnd))) {
            if (c.length() <= 0) continue;
            args.add(c);
        }
        return args.toArray(new String[args.size()]);
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public void setDelay(String delay) {
        this.delay = Long.parseLong(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        EventSwitchManager eventSwitchManager = this.manager = EventSwitchManager.getInstance();
        synchronized (eventSwitchManager) {
            for (String c : this.configuration.split("\\\r|\\\n")) {
                final String[] args = MBeanCmdWrapper.parseCommandLine(c);
                if (args.length <= 0) continue;
                boolean jasmineOption = false;
                boolean jasmineItem = false;
                for (String arg : args) {
                    if (jasmineOption) {
                        if (arg.length() <= 0) break;
                        jasmineItem = true;
                        break;
                    }
                    if (!arg.equals("-jasmine")) continue;
                    jasmineOption = true;
                }
                if (!jasmineOption || !jasmineItem) {
                    throw new IllegalArgumentException("-jasmine option not specified for the MBeanCmd container");
                }
                Thread t = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        long time = System.currentTimeMillis();
                        1 var3_2 = this;
                        synchronized (var3_2) {
                            while (System.currentTimeMillis() < time + MBeanCmdWrapper.this.delay) {
                                try {
                                    this.wait(MBeanCmdWrapper.this.delay);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        CommandDispatcher.start((String[])args);
                    }
                };
                this.manager.addMBeanCmdCommand(c, t);
                t.start();
            }
        }
    }

    public void stop() {
        this.manager.stopAllMBeanCmdCommands();
    }
}

