/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import java.io.Serializable;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.TextMessage;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.ow2.jasmine.event.beans.JasmineEventEB;

public class JMSTextMessageToJasmineEvent
extends AbstractTransformer {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private String domainName = null;
    private String serverName = null;
    private String sourceName = null;
    private String sname = null;

    public JMSTextMessageToJasmineEvent() {
        this.registerSourceType(TextMessage.class);
        this.setReturnClass(JasmineEventEB.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        JasmineEventEB event = null;
        try {
            TextMessage textMessage = (TextMessage)src;
            String text = textMessage.getText();
            Date timestamp = new Date(textMessage.getJMSTimestamp());
            event = new JasmineEventEB(this.domainName, this.serverName, "JMS", this.sourceName, (Serializable)((Object)text), timestamp, this.sname);
            this.logger.finest("Sending event " + event);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Transformer exception", e);
            throw new TransformerException((UMOTransformer)this, (Throwable)e);
        }
        return event;
    }
}

