/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import java.text.SimpleDateFormat;
import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotificationDetail;

public class JasmineEventNotificationToCSV
extends AbstractTransformer {
    public JasmineEventNotificationToCSV() {
        this.registerSourceType(JasmineEventNotification.class);
        this.setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        String result = "";
        String split = ";";
        if (src instanceof JasmineEventNotification) {
            JasmineEventNotification event = (JasmineEventNotification)src;
            result = result + event.getId() + ";" + event.getLevel() + ";" + event.getMessage() + ";" + new SimpleDateFormat("MM/dd/yyyy, HH:mm:ss z").format(event.getDate()) + ";" + event.getMessage() + ";" + event.getStatus() + ";";
            if (!event.getDetails().isEmpty()) {
                for (JasmineEventNotificationDetail entry : event.getDetails()) {
                    result = result + entry.getLabel() + ":" + entry.getMessage();
                }
            }
        } else {
            throw new IllegalArgumentException("Unable to transform this source type: " + src.getClass().getName());
        }
        result = result + "\n";
        return result;
    }
}

