/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import org.mule.transformers.AbstractTransformer;
import org.mule.umo.transformer.TransformerException;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;

public class JasmineEventToCSV
extends AbstractTransformer {
    private static final String SEPARATOR = ";";

    public JasmineEventToCSV() {
        this.registerSourceType(JasmineEvent.class);
        this.registerSourceType(JasmineEventEB.class);
        this.setReturnClass(String.class);
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        StringBuffer buffer = new StringBuffer();
        if (src instanceof JasmineEvent) {
            JasmineEvent event = (JasmineEvent)src;
            String domain = event.getDomain();
            String server = event.getServer();
            for (JasmineEventDetails ed : event.getEvents()) {
                buffer.append(ed.getTimestamp().getTime());
                buffer.append(SEPARATOR);
                buffer.append(ed.getTimestamp());
                buffer.append(SEPARATOR);
                buffer.append(ed.getSname());
                buffer.append(SEPARATOR);
                buffer.append(domain);
                buffer.append(SEPARATOR);
                buffer.append(server);
                buffer.append(SEPARATOR);
                buffer.append(ed.getProbe());
                buffer.append(SEPARATOR);
                buffer.append(ed.getValue());
                buffer.append("\n");
            }
        } else if (src instanceof JasmineEventEB) {
            JasmineEventEB event = (JasmineEventEB)src;
            buffer.append(event.getTimestamp().getTime());
            buffer.append(SEPARATOR);
            buffer.append(event.getTimestamp());
            buffer.append(SEPARATOR);
            buffer.append(event.getSname());
            buffer.append(SEPARATOR);
            buffer.append(event.getDomain());
            buffer.append(SEPARATOR);
            buffer.append(event.getServer());
            buffer.append(SEPARATOR);
            buffer.append(event.getProbe());
            buffer.append(SEPARATOR);
            buffer.append(event.getValue());
            buffer.append("\n");
        } else {
            throw new IllegalArgumentException("Unable to transform this source type: " + src.getClass().getName());
        }
        return buffer.toString();
    }
}

