/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.transformers;

import java.text.SimpleDateFormat;
import org.mule.transformers.AbstractTransformer;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.event.messages.JasmineEvent;
import org.ow2.jasmine.event.messages.JasmineEventDetails;

public class JasmineEventToString
extends AbstractTransformer {
    public JasmineEventToString() {
        this.registerSourceType(JasmineEvent.class);
        this.registerSourceType(JasmineEventEB.class);
        this.setReturnClass(String.class);
    }

    public Object doTransform(Object src, String encoding) {
        String result;
        if (src instanceof JasmineEvent) {
            JasmineEvent event = (JasmineEvent)src;
            result = "JASMINe Event object for " + event.getDomain() + "." + event.getServer() + " has " + event.getEvents().size() + " events:";
            for (JasmineEventDetails ed : event.getEvents()) {
                result = result + "\n\tProbe:  " + ed.getProbe() + "\n\tTime:   " + new SimpleDateFormat("MM/dd/yyyy, HH:mm:ss z").format(ed.getTimestamp()) + "\n\tValue:  " + ed.getValue() + "\n\t\t-----";
            }
        } else if (src instanceof JasmineEventEB) {
            JasmineEventEB event = (JasmineEventEB)src;
            result = "JASMINe Event EB object for " + event.getDomain() + "." + event.getServer() + ":" + "\n\tProbe:  " + event.getProbe() + "\n\tTime:   " + new SimpleDateFormat("MM/dd/yyyy, HH:mm:ss z").format(event.getTimestamp()) + "\n\tValue:  " + event.getValue() + "\n\t\t-----";
        } else {
            throw new IllegalArgumentException("Unable to transform this source type: " + src.getClass().getName());
        }
        return result;
    }
}

