/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleException;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.umo.UMOException;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;
import org.mule.util.MuleUrlStreamHandlerFactory;
import org.mule.util.StringMessageUtils;
import org.mule.util.SystemUtils;

public class MuleServer
implements Runnable {
    public static final String[][] CLI_OPTIONS = new String[][]{{"builder", "true", "Configuration Builder Type"}, {"config", "true", "Configuration File"}, {"main", "true", "Main Class"}, {"mode", "true", "Run Mode"}, {"props", "true", "Startup Properties"}};
    protected static final String CLASSNAME_DEFAULT_CONFIG_BUILDER = "org.mule.config.builders.MuleXmlConfigurationBuilder";
    protected static final String CLASSNAME_SPRING_CONFIG_BUILDER = "org.mule.extras.spring.config.SpringConfigurationBuilder";
    private static Log logger = LogFactory.getLog(MuleServer.class);
    public static final String DEFAULT_CONFIGURATION = "mule-config.xml";
    private static String shutdownMessage = null;
    private String configurationResources = null;
    private static String configBuilderClassName = null;
    private static String startupPropertiesFile = null;

    public static void main(String[] args) {
        String propertiesFile;
        MuleServer server = new MuleServer();
        Map options = Collections.EMPTY_MAP;
        try {
            options = SystemUtils.getCommandLineOptions(args, CLI_OPTIONS);
        }
        catch (MuleException me) {
            System.err.println(me.toString());
            System.exit(1);
        }
        MuleUrlStreamHandlerFactory.installUrlStreamHandlerFactory();
        String config = (String)options.get("config");
        if (config == null) {
            logger.warn("A configuration file was not set, using default: mule-config.xml");
            URL configUrl = IOUtils.getResourceAsUrl(DEFAULT_CONFIGURATION, MuleServer.class, true);
            if (configUrl != null) {
                config = configUrl.toExternalForm();
            }
        }
        if (config != null) {
            server.setConfigurationResources(config);
        } else {
            Message message = CoreMessages.configNotFoundUsage();
            System.err.println(message.toString());
            System.exit(1);
        }
        String cfgBuilderClassName = (String)options.get("builder");
        if (cfgBuilderClassName != null) {
            try {
                if (cfgBuilderClassName.equalsIgnoreCase("spring")) {
                    cfgBuilderClassName = CLASSNAME_SPRING_CONFIG_BUILDER;
                }
                MuleServer.setConfigBuilderClassName(cfgBuilderClassName);
            }
            catch (Exception e) {
                logger.fatal(e);
                Message message = CoreMessages.failedToLoad("Builder: " + cfgBuilderClassName);
                System.err.println(StringMessageUtils.getBoilerPlate("FATAL: " + message.toString()));
                System.exit(1);
            }
        }
        if ((propertiesFile = (String)options.get("props")) != null) {
            MuleServer.setStartupPropertiesFile(propertiesFile);
        }
        server.start(false);
    }

    public MuleServer() {
    }

    public MuleServer(String configResources) {
        this.setConfigurationResources(configResources);
    }

    public void start(boolean ownThread) {
        if (ownThread) {
            Thread serverThread = new Thread((Runnable)this, "MuleServer");
            serverThread.setDaemon(true);
            serverThread.start();
        } else {
            this.run();
        }
    }

    public void run() {
        try {
            this.initialize();
        }
        catch (Throwable e) {
            this.shutdown(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setConfigBuilderClassName(String builderClassName) throws ClassNotFoundException {
        if (builderClassName != null) {
            Class cls;
            if (!ConfigurationBuilder.class.isAssignableFrom(cls = ClassUtils.loadClass(builderClassName, MuleServer.class))) throw new IllegalArgumentException("Not a usable ConfigurationBuilder class: " + builderClassName);
            configBuilderClassName = builderClassName;
            return;
        } else {
            configBuilderClassName = null;
        }
    }

    public static String getConfigBuilderClassName() {
        if (configBuilderClassName != null) {
            return configBuilderClassName;
        }
        return CLASSNAME_DEFAULT_CONFIG_BUILDER;
    }

    protected void initialize() throws Exception {
        logger.info("Mule Server starting...");
        Class cfgBuilderClass = ClassUtils.loadClass(MuleServer.getConfigBuilderClassName(), MuleServer.class);
        ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)cfgBuilderClass.newInstance();
        if (!cfgBuilder.isConfigured()) {
            if (this.configurationResources == null) {
                logger.warn("A configuration file was not set, using default: mule-config.xml");
                this.configurationResources = DEFAULT_CONFIGURATION;
            }
            cfgBuilder.configure(this.configurationResources, MuleServer.getStartupPropertiesFile());
        }
        logger.info("Mule Server initialized.");
    }

    void shutdown(Throwable e) {
        Message msg = CoreMessages.fatalErrorWhileRunning();
        UMOException muleException = ExceptionHelper.getRootMuleException(e);
        if (muleException != null) {
            logger.fatal(muleException.getDetailedMessage());
        } else {
            logger.fatal(msg.toString() + " " + e.getMessage(), e);
        }
        ArrayList<Object> msgs = new ArrayList<Object>();
        msgs.add(msg.getMessage());
        Throwable root = ExceptionHelper.getRootException(e);
        msgs.add(root.getMessage() + " (" + root.getClass().getName() + ")");
        msgs.add(" ");
        msgs.add(CoreMessages.fatalErrorInShutdown());
        msgs.add(CoreMessages.serverStartedAt(MuleManager.getInstance().getStartDate()));
        msgs.add(CoreMessages.serverShutdownAt(new Date()));
        shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, '*', 80);
        logger.fatal(shutdownMessage);
        System.exit(0);
    }

    void shutdown() {
        logger.info("Mule server shutting dow due to normal shutdown request");
        ArrayList<Object> msgs = new ArrayList<Object>();
        msgs.add(CoreMessages.normalShutdown());
        msgs.add(CoreMessages.serverStartedAt(MuleManager.getInstance().getStartDate()).getMessage());
        msgs.add(CoreMessages.serverShutdownAt(new Date()).getMessage());
        shutdownMessage = StringMessageUtils.getBoilerPlate(msgs, '*', 80);
        System.exit(0);
    }

    public String getConfigurationResources() {
        return this.configurationResources;
    }

    public void setConfigurationResources(String configurationResources) {
        this.configurationResources = configurationResources;
    }

    public static String getStartupPropertiesFile() {
        return startupPropertiesFile;
    }

    public static void setStartupPropertiesFile(String startupPropertiesFile) {
        MuleServer.startupPropertiesFile = startupPropertiesFile;
    }
}

