/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers;

import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.config.i18n.CoreMessages;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.PollingReceiverWorker;
import org.mule.providers.PollingReceiverWorkerSchedule;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.ObjectUtils;

public abstract class AbstractPollingMessageReceiver
extends AbstractMessageReceiver {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final TimeUnit DEFAULT_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    public static final long DEFAULT_STARTUP_DELAY = 1000L;
    private long frequency = 1000L;
    private TimeUnit timeUnit = DEFAULT_POLL_TIMEUNIT;
    protected final List schedules = new LinkedList();

    public AbstractPollingMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws UMOException {
        try {
            List list = this.schedules;
            synchronized (list) {
                ScheduledFuture schedule = this.connector.getScheduler().scheduleWithFixedDelay(new PollingReceiverWorkerSchedule(this.createWork()), 1000L, this.getFrequency(), this.getTimeUnit());
                this.schedules.add(schedule);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(ObjectUtils.identityToShortString(this) + " scheduled " + ObjectUtils.identityToShortString(schedule) + " with " + this.frequency + " " + this.getTimeUnit() + " polling frequency");
                }
            }
        }
        catch (Exception ex) {
            this.stop();
            throw new InitialisationException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws UMOException {
        List list = this.schedules;
        synchronized (list) {
            Iterator i = this.schedules.iterator();
            while (i.hasNext()) {
                ScheduledFuture schedule = (ScheduledFuture)i.next();
                schedule.cancel(false);
                i.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug(ObjectUtils.identityToShortString(this) + " cancelled polling schedule: " + ObjectUtils.identityToShortString(schedule));
            }
        }
    }

    protected PollingReceiverWorker createWork() {
        return new PollingReceiverWorker(this);
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long value) {
        this.frequency = value <= 0L ? 1000L : value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public abstract void poll() throws Exception;
}

