/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.SerializationUtils;
import org.mule.impl.MuleMessage;
import org.mule.impl.ThreadSafeAccess;
import org.mule.providers.AbstractMessageAdapter;

public class TcpMessageAdapter
extends AbstractMessageAdapter {
    private static final long serialVersionUID = 7229837140160407794L;
    private Object message;

    public TcpMessageAdapter(Object message) {
        if (message instanceof MuleMessage) {
            MuleMessage muleMessage = (MuleMessage)message;
            Iterator names = muleMessage.getPropertyNames().iterator();
            while (names.hasNext()) {
                Object name = names.next();
                this.properties.put(name, muleMessage.getProperty(name.toString()));
            }
            this.message = muleMessage.getPayload();
        } else {
            this.message = message;
        }
    }

    protected TcpMessageAdapter(TcpMessageAdapter template) {
        super(template);
        this.message = template.message;
    }

    public String getPayloadAsString(String encoding) throws Exception {
        if (this.message instanceof byte[]) {
            return new String((byte[])this.message, encoding);
        }
        return this.message.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.message instanceof byte[]) {
            return (byte[])this.message;
        }
        return SerializationUtils.serialize((Serializable)this.message);
    }

    public Object getPayload() {
        return this.message;
    }

    public ThreadSafeAccess newThreadCopy() {
        return new TcpMessageAdapter(this);
    }
}

