/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.filters.xml;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.mule.umo.UMOFilter;
import org.mule.umo.UMOMessage;
import org.mule.util.StringMessageUtils;

public class JXPathFilter
implements UMOFilter {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private String expression;
    private String expectedValue;
    private Map namespaces = null;
    private Map contextProperties = null;
    private AbstractFactory factory;
    private boolean lenient = true;

    public JXPathFilter() {
    }

    public JXPathFilter(String expression) {
        this.expression = expression;
    }

    public JXPathFilter(String expression, String expectedValue) {
        this.expression = expression;
        this.expectedValue = expectedValue;
    }

    public boolean accept(UMOMessage obj) {
        return this.accept(obj.getPayload());
    }

    private boolean accept(Object obj) {
        if (obj == null) {
            this.logger.warn("Applying JXPathFilter to null object.");
            return false;
        }
        if (this.expression == null) {
            this.logger.warn("Expression for JXPathFilter is not set.");
            return false;
        }
        if (this.expectedValue == null) {
            if (this.expression.endsWith("= null") || this.expression.endsWith("=null")) {
                this.expectedValue = "null";
                this.expression = this.expression.substring(0, this.expression.lastIndexOf("="));
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Expected value for JXPathFilter is not set, using 'true' by default");
                }
                this.expectedValue = Boolean.TRUE.toString();
            }
        }
        Object xpathResult = null;
        boolean accept = false;
        if (obj instanceof Document) {
            if (this.namespaces == null) {
                xpathResult = ((Document)obj).valueOf(this.expression);
            } else {
                XPath xpath = DocumentHelper.createXPath(this.expression);
                xpath.setNamespaceURIs(this.namespaces);
                xpathResult = xpath.valueOf(obj);
            }
        } else {
            if (obj instanceof String) {
                try {
                    return this.accept(DocumentHelper.parseText((String)obj));
                }
                catch (DocumentException e) {
                    this.logger.warn("JXPathFilter unable to parse XML document: " + e.getMessage(), e);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("XML = " + StringMessageUtils.truncate((String)obj, 200, false));
                    }
                    return false;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Passing object of type " + obj.getClass().getName() + " to JXPathContext");
            }
            JXPathContext context = JXPathContext.newContext((Object)obj);
            this.initialise(context);
            xpathResult = context.getValue(this.expression);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JXPathFilter Expression result = '" + xpathResult + "' -  Expected value = '" + this.expectedValue + "'");
        }
        if (xpathResult != null) {
            accept = xpathResult.toString().equals(this.expectedValue);
        } else if (this.expectedValue.equals("null")) {
            accept = true;
        } else {
            this.logger.warn("JXPathFilter expression evaluates to null: " + this.expression);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JXPathFilter accept object  : " + accept);
        }
        return accept;
    }

    protected void initialise(JXPathContext context) {
        Iterator iterator;
        Map.Entry entry = null;
        if (this.namespaces != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing JXPathContext with namespaces: " + this.namespaces);
            }
            iterator = this.namespaces.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                context.registerNamespace(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        if (this.contextProperties != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Initializing JXPathContext with properties: " + this.contextProperties);
            }
            iterator = this.contextProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                context.setValue(entry.getKey().toString(), entry.getValue());
            }
        }
        if (this.factory != null) {
            context.setFactory(this.factory);
        }
        context.setLenient(this.lenient);
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public String getValue() {
        return this.getExpectedValue();
    }

    public void setValue(String value) {
        this.setExpectedValue(value);
    }

    public Map getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map namespaces) {
        this.namespaces = namespaces;
    }

    public Map getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Map contextProperties) {
        this.contextProperties = contextProperties;
    }

    public AbstractFactory getFactory() {
        return this.factory;
    }

    public void setFactory(AbstractFactory factory) {
        this.factory = factory;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }
}

