/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.graph;

import java.io.IOException;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.ow2.jasmine.monitoring.mbeancmd.Outer;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Graph;
import org.ow2.jasmine.monitoring.mbeancmd.graph.Serie;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configuration;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.Configurator;
import org.ow2.jasmine.monitoring.mbeancmd.graph.conf.GraphConfig;

public class Grapher {
    private Configuration config = new Configurator();
    private Serie[] series = null;
    private Outer[] outers = null;

    public static void main(String[] args) throws IOException {
        PipedOutputStream src = new PipedOutputStream();
        PrintWriter wsrc = new PrintWriter(src);
        Grapher g = new Grapher(src, "src/xml/graphtest2.xml");
        g.start();
        Grapher.injectData(wsrc, g);
        src.close();
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void injectData(PrintWriter pr, Grapher g) {
        String[] names = new String[]{"fwa:type=aaa,name=n00", "fwa:type=bbb,name=n01", "fwa:type=aaa,name=n02", "fwa:type=aaa,name=n03", "fwa:type=bbb,name=n04", "fwa:type=bbb,name=n05", "fwa:type=aaa,name=n06", "fwa:type=aaa,name=n07", "fwa:type=aaa,name=n08", "fwa:type=bbb,name=n09", "fwa:type=bbb,name=n10"};
        String sep = ";";
        SimpleDateFormat df = g.config.getDateFormat();
        pr.println("time" + sep + "a" + sep + "b" + sep + "c" + sep + "d" + sep + "e" + sep + "f" + sep + "name");
        for (int i = 1; i <= 60; ++i) {
            long t = System.currentTimeMillis() + (long)i;
            pr.print((df == null ? Long.toString(t) : df.format(new Date(t))) + sep + (100 + i) + sep + (200 + i) + sep + (300 + i) + sep + (400 + i) + sep + (500 + i) + sep + (600 + i) + sep + names[(i - 1) % 10] + (i == 100 ? "" : "\n"));
            pr.flush();
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public Grapher(PipedOutputStream in, String definitions) throws IOException {
        this.config.loadConfig(definitions);
        String[] sids = this.config.getSerieIds();
        this.series = new Serie[sids.length];
        this.outers = new Outer[sids.length + 1];
        for (int i = 0; i < sids.length; ++i) {
            this.series[i] = new Serie(this.config.getSerieConfig(sids[i]));
            this.outers[i] = new Outer(i == 0 ? in : this.outers[i - 1].getSink(), new PrintStream(this.series[i].getSource()));
            this.outers[i].setSink(new PipedOutputStream());
            String[] format = new String[]{this.series[i].getConfig().getXAxis(), this.series[i].getConfig().getYAxis()};
            this.outers[i].setFormatter(format);
            this.outers[i].setRegexp(this.series[i].getConfig().getMbeanPattern());
        }
        this.outers[this.outers.length - 1] = new Outer(this.outers[this.outers.length - 2].getSink(), (PrintStream)null);
        Outer.setSeparator(this.config.getSeparator());
        String[] gids = this.config.getGraphIds();
        Graph[] graphs = new Graph[gids.length];
        for (int i = 0; i < graphs.length; ++i) {
            GraphConfig gcf = this.config.getGraphConfig(gids[i]);
            graphs[i] = new Graph(gcf);
            String[] gseries = gcf.getSerieIds();
            for (int j = 0; j < gseries.length; ++j) {
                for (int k = 0; k < this.series.length; ++k) {
                    if (!gseries[j].equals(this.series[k].getConfig().getId())) continue;
                    this.series[k].addSerieListener(graphs[i]);
                }
            }
        }
    }

    public void start() {
        int i;
        for (i = 0; i < this.series.length; ++i) {
            new Thread(this.series[i]).start();
        }
        for (i = this.outers.length - 1; i >= 0; --i) {
            new Thread(this.outers[i]).start();
        }
    }
}

