/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoramQData
extends SampleData {
    private static final String header = "AdminName;PendingMessages;NbMaxMsg;receiveRate;deliveryRate;PendingRequests;creationDate;nbMsgsReceiveSinceCreation;nbMsgsDeliverSinceCreation;nbMsgsSentToDMQSinceCreation";

    @Override
    public void compute(SampleData needs_cast) {
        JoramQData prev = (JoramQData)needs_cast;
        if (prev != null) {
            long deltaReceived = this.getAttributeAsLong("NbMsgsReceiveSinceCreation") - prev.getAttributeAsLong("NbMsgsReceiveSinceCreation");
            double dt = (double)(this.getSampleTime() - prev.getSampleTime()) / 1000.0;
            this.setAttribute(new Attribute("receiveRate", new Double((double)deltaReceived / dt)));
            long deltaDelivery = this.getAttributeAsLong("NbMsgsDeliverSinceCreation") - prev.getAttributeAsLong("NbMsgsDeliverSinceCreation");
            this.setAttribute(new Attribute("deliveryRate", new Double((double)deltaDelivery / dt)));
        } else {
            this.setAttribute(new Attribute("receiveRate", new Double(0.0)));
            this.setAttribute(new Attribute("deliveryRate", new Double(0.0)));
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", JoramQData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        Long msgToDMQCount = 0L;
        try {
            msgToDMQCount = this.getAttributeAsLong("NbMsgsSentToDMQSinceCreation");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (msgToDMQCount == null) {
            msgToDMQCount = this.getAttributeAsLong("NbMsgsSendToDMQSinceCreation");
        }
        return this.getAttribute("AdminName") + JoramQData.getSeparator() + this.getAttributeAsInt("PendingMessageCount") + JoramQData.getSeparator() + this.getAttributeAsInt("NbMaxMsg") + JoramQData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("receiveRate")) + JoramQData.getSeparator() + decimalFormat.format(this.getAttributeAsDouble("deliveryRate")) + JoramQData.getSeparator() + this.getAttributeAsInt("WaitingRequestCount") + JoramQData.getSeparator() + this.getAttributeAsLong("CreationTimeInMillis") + JoramQData.getSeparator() + this.getAttributeAsLong("NbMsgsReceiveSinceCreation") + JoramQData.getSeparator() + this.getAttributeAsLong("NbMsgsDeliverSinceCreation") + JoramQData.getSeparator() + msgToDMQCount;
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Object> valueOfAttributes = new HashMap<String, Object>();
        valueOfAttributes.put("AdminName", this.getAttribute("AdminName"));
        valueOfAttributes.put("PendingMessageCount", this.getAttributeAsInt("PendingMessageCount"));
        valueOfAttributes.put("NbMaxMsg", this.getAttributeAsInt("NbMaxMsg"));
        valueOfAttributes.put("receiveRate", this.getAttributeAsDouble("receiveRate"));
        valueOfAttributes.put("deliveryRate", this.getAttributeAsDouble("deliveryRate"));
        valueOfAttributes.put("WaitingRequestCount", this.getAttributeAsInt("WaitingRequestCount"));
        valueOfAttributes.put("CreationTimeInMillis", this.getAttributeAsLong("creationDate"));
        valueOfAttributes.put("nbMsgsReceiveSinceCreation", this.getAttributeAsLong("nbMsgsReceiveSinceCreation"));
        valueOfAttributes.put("nbMsgsDeliverSinceCreation", this.getAttributeAsLong("nbMsgsDeliverSinceCreation"));
        valueOfAttributes.put("nbMsgsSentToDMQSinceCreation", this.getAttributeAsLong("nbMsgsSentToDMQSinceCreation"));
        return valueOfAttributes;
    }
}

