/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApplicationMap
extends BaseContextMap {
    private final ServletContext servletContext;

    ApplicationMap(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public void clear() {
        Enumeration e = this.servletContext.getAttributeNames();
        while (e.hasMoreElements()) {
            this.servletContext.removeAttribute((String)e.nextElement());
        }
    }

    @Override
    public void putAll(Map t) {
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.servletContext.setAttribute((String)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.servletContext.getAttribute(key.toString());
    }

    @Override
    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        Object result = this.servletContext.getAttribute(key.toString());
        this.servletContext.setAttribute(key.toString(), value);
        return result;
    }

    @Override
    public Object remove(Object key) {
        if (key == null) {
            return null;
        }
        String keyString = key.toString();
        Object result = this.servletContext.getAttribute(keyString);
        this.servletContext.removeAttribute(keyString);
        return result;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.servletContext.getAttribute(key.toString()) != null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj instanceof ApplicationMap && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hashCode = 7 * this.servletContext.hashCode();
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            hashCode += i.next().hashCode();
        }
        return hashCode;
    }

    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(this, this.servletContext.getAttributeNames());
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(this, this.servletContext.getAttributeNames());
    }

    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(this, this.servletContext.getAttributeNames());
    }
}

