/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import java.util.Vector;
import javax.mail.internet.ParameterList;

public class BODYSTRUCTURE
implements Item {
    public static char[] name = new char[]{'B', 'O', 'D', 'Y', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E'};
    public int msgno;
    public String type;
    public String subtype;
    public String encoding;
    public int lines = -1;
    public int size = -1;
    public String disposition;
    public String id;
    public String description;
    public String md5;
    public String attachment;
    public ParameterList cParams;
    public ParameterList dParams;
    public String[] language;
    public BODYSTRUCTURE[] bodies;
    public ENVELOPE envelope;
    private static int SINGLE = 1;
    private static int MULTI = 2;
    private static int NESTED = 3;
    private int processedType;

    public BODYSTRUCTURE(FetchResponse r) throws ParsingException {
        this.msgno = r.getNumber();
        r.skipSpaces();
        if (r.readByte() != 40) {
            throw new ParsingException("BODYSTRUCTURE parse error: missing ``('' at start");
        }
        if (r.peekByte() == 40) {
            this.type = "multipart";
            this.processedType = MULTI;
            Vector v = new Vector(1);
            boolean i = true;
            do {
                v.addElement(new BODYSTRUCTURE(r));
                r.skipSpaces();
            } while (r.peekByte() == 40);
            this.bodies = new BODYSTRUCTURE[v.size()];
            v.copyInto(this.bodies);
            this.subtype = r.readString();
            if (r.readByte() == 41) {
                return;
            }
            this.cParams = this.parseParameters(r);
            if (r.readByte() == 41) {
                return;
            }
            byte b = r.readByte();
            if (b == 40) {
                this.disposition = r.readString();
                this.dParams = this.parseParameters(r);
                if (r.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition in multipart");
                }
            } else if (b == 78 || b == 110) {
                r.skip(2);
            } else {
                throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": " + "bad multipart disposition, b " + b);
            }
            if ((b = r.readByte()) == 41) {
                return;
            }
            if (b != 32) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing space after disposition");
            }
            if (r.peekByte() == 40) {
                this.language = r.readStringList();
            } else {
                String l = r.readString();
                if (l != null) {
                    String[] la = new String[]{l};
                    this.language = la;
                }
            }
            while (r.readByte() == 32) {
                this.parseBodyExtension(r);
            }
        } else {
            this.type = r.readString();
            this.processedType = SINGLE;
            this.subtype = r.readString();
            if (this.type == null) {
                this.type = "application";
                this.subtype = "octet-stream";
            }
            this.cParams = this.parseParameters(r);
            this.id = r.readString();
            this.description = r.readString();
            this.encoding = r.readString();
            this.size = r.readNumber();
            if (this.size < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``size'' element");
            }
            if (this.type.equalsIgnoreCase("text")) {
                this.lines = r.readNumber();
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else if (this.type.equalsIgnoreCase("message") && this.subtype.equalsIgnoreCase("rfc822")) {
                this.processedType = NESTED;
                this.envelope = new ENVELOPE(r);
                BODYSTRUCTURE[] bs = new BODYSTRUCTURE[]{new BODYSTRUCTURE(r)};
                this.bodies = bs;
                this.lines = r.readNumber();
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else {
                r.skipSpaces();
                byte bn = r.peekByte();
                if (Character.isDigit((char)bn)) {
                    throw new ParsingException("BODYSTRUCTURE parse error: server erroneously included ``lines'' element with type " + this.type + "/" + this.subtype);
                }
            }
            if (r.peekByte() == 41) {
                r.readByte();
                return;
            }
            this.md5 = r.readString();
            if (r.readByte() == 41) {
                return;
            }
            byte b = r.readByte();
            if (b == 40) {
                this.disposition = r.readString();
                this.dParams = this.parseParameters(r);
                if (r.readByte() != 41) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition");
                }
            } else if (b == 78 || b == 110) {
                r.skip(2);
            } else {
                throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": " + "bad single part disposition, b " + b);
            }
            if (r.readByte() == 41) {
                return;
            }
            if (r.peekByte() == 40) {
                this.language = r.readStringList();
            } else {
                String l = r.readString();
                if (l != null) {
                    String[] la = new String[]{l};
                    this.language = la;
                }
            }
            while (r.readByte() == 32) {
                this.parseBodyExtension(r);
            }
        }
    }

    public boolean isMulti() {
        return this.processedType == MULTI;
    }

    public boolean isSingle() {
        return this.processedType == SINGLE;
    }

    public boolean isNested() {
        return this.processedType == NESTED;
    }

    private ParameterList parseParameters(Response r) throws ParsingException {
        r.skipSpaces();
        ParameterList list = null;
        byte b = r.readByte();
        if (b == 40) {
            list = new ParameterList();
            do {
                String name = r.readString();
                String value = r.readString();
                list.set(name, value);
            } while (r.readByte() != 41);
        } else if (b == 78 || b == 110) {
            r.skip(2);
        } else {
            throw new ParsingException("Parameter list parse error");
        }
        return list;
    }

    private void parseBodyExtension(Response r) throws ParsingException {
        r.skipSpaces();
        byte b = r.peekByte();
        if (b == 40) {
            r.skip(1);
            do {
                this.parseBodyExtension(r);
            } while (r.readByte() != 41);
        } else if (Character.isDigit((char)b)) {
            r.readNumber();
        } else {
            r.readString();
        }
    }
}

