/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;

public abstract class LogFactory {
    protected static final String FACTORY_DEFAULT = "org.apache.commons.logging.impl.LogFactoryImpl";
    protected static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    protected static Hashtable factories = new Hashtable();
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$org$apache$commons$logging$LogFactory;

    protected LogFactory() {
    }

    public abstract Object getAttribute(String var1);

    public abstract String[] getAttributeNames();

    public abstract Log getInstance(Class var1) throws LogConfigurationException;

    public abstract Log getInstance(String var1) throws LogConfigurationException;

    public abstract void release();

    public abstract void removeAttribute(String var1);

    public abstract void setAttribute(String var1, Object var2);

    public static LogFactory getFactory() throws LogConfigurationException {
        LogFactory factory;
        ClassLoader classLoader;
        block19: {
            classLoader = LogFactory.findClassLoader();
            factory = (LogFactory)factories.get(classLoader);
            if (factory != null) {
                return factory;
            }
            try {
                String factoryClass = System.getProperty(FACTORY_PROPERTY);
                if (factoryClass != null) {
                    factory = LogFactory.newFactory(factoryClass, classLoader);
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (factory == null) {
                try {
                    BufferedReader rd;
                    InputStream is = null;
                    is = classLoader == null ? ClassLoader.getSystemResourceAsStream(SERVICE_ID) : classLoader.getResourceAsStream(SERVICE_ID);
                    if (is == null) break block19;
                    try {
                        rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        rd = new BufferedReader(new InputStreamReader(is));
                    }
                    String factoryClassName = rd.readLine();
                    rd.close();
                    if (factoryClassName != null && !"".equals(factoryClassName)) {
                        factory = LogFactory.newFactory(factoryClassName, classLoader);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        Properties props = null;
        try {
            InputStream stream = classLoader.getResourceAsStream(FACTORY_PROPERTIES);
            if (stream != null) {
                props = new Properties();
                props.load(stream);
                stream.close();
                String factoryClass = props.getProperty(FACTORY_PROPERTY);
                if (factory == null) {
                    if (factoryClass == null) {
                        factoryClass = FACTORY_DEFAULT;
                    }
                    factory = LogFactory.newFactory(factoryClass, classLoader);
                }
            }
        }
        catch (IOException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (factory == null) {
            factory = LogFactory.newFactory(FACTORY_DEFAULT, classLoader);
        }
        if (props != null) {
            Enumeration names = props.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = props.getProperty(name);
                factory.setAttribute(name, value);
            }
        }
        factories.put(classLoader, factory);
        return factory;
    }

    public static Log getLog(Class clazz) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(clazz);
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void releaseAll() {
        Hashtable hashtable = factories;
        synchronized (hashtable) {
            Enumeration elements = factories.elements();
            while (elements.hasMoreElements()) {
                LogFactory element = (LogFactory)elements.nextElement();
                element.release();
            }
            factories.clear();
        }
    }

    protected static ClassLoader findClassLoader() throws LogConfigurationException {
        Method method = null;
        try {
            method = (class$java$lang$Thread == null ? (class$java$lang$Thread = LogFactory.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException e) {
            return (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
        }
        ClassLoader classLoader = null;
        try {
            classLoader = (ClassLoader)method.invoke(Thread.currentThread(), null);
            if (classLoader == null) {
                classLoader = (class$org$apache$commons$logging$LogFactory == null ? (class$org$apache$commons$logging$LogFactory = LogFactory.class$(FACTORY_PROPERTY)) : class$org$apache$commons$logging$LogFactory).getClassLoader();
            }
        }
        catch (IllegalAccessException e) {
            throw new LogConfigurationException("Unexpected IllegalAccessException", e);
        }
        catch (InvocationTargetException e) {
            throw new LogConfigurationException("Unexpected InvocationTargetException", e);
        }
        return classLoader;
    }

    protected static LogFactory newFactory(String factoryClass, ClassLoader classLoader) throws LogConfigurationException {
        try {
            Class clazz = null;
            if (classLoader == null) {
                clazz = Class.forName(factoryClass);
            } else {
                try {
                    clazz = classLoader.loadClass(factoryClass);
                }
                catch (ClassNotFoundException ex) {
                    clazz = Class.forName(factoryClass);
                }
            }
            return (LogFactory)clazz.newInstance();
        }
        catch (Exception e) {
            throw new LogConfigurationException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

