/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceCache;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.runtime.resource.ResourceFactory;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoaderFactory;

public class ResourceManagerImpl
implements ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    private static final String RESOURCE_LOADER_IDENTIFIER = "_RESOURCE_LOADER_IDENTIFIER_";
    protected ResourceCache globalCache = null;
    protected ArrayList resourceLoaders = new ArrayList();
    private ArrayList sourceInitializerList = new ArrayList();
    private Hashtable sourceInitializerMap = new Hashtable();
    private boolean resourceLoaderInitializersActive = false;
    private boolean logWhenFound = true;
    protected RuntimeServices rsvc = null;

    public void initialize(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        this.rsvc.info("Default ResourceManager initializing. (" + this.getClass() + ")");
        this.assembleResourceLoaderInitializers();
        int i = 0;
        while (i < this.sourceInitializerList.size()) {
            ExtendedProperties configuration = (ExtendedProperties)this.sourceInitializerList.get(i);
            String loaderClass = configuration.getString("class");
            if (loaderClass == null) {
                this.rsvc.error("Unable to find '" + configuration.getString(RESOURCE_LOADER_IDENTIFIER) + ".resource.loader.class' specification in configuation." + " This is a critical value.  Please adjust configuration.");
            } else {
                ResourceLoader resourceLoader = ResourceLoaderFactory.getLoader(this.rsvc, loaderClass);
                resourceLoader.commonInit(this.rsvc, configuration);
                resourceLoader.init(configuration);
                this.resourceLoaders.add(resourceLoader);
            }
            ++i;
        }
        this.logWhenFound = this.rsvc.getBoolean("resource.manager.logwhenfound", true);
        String claz = this.rsvc.getString("resource.manager.cache.class");
        Object o = null;
        if (claz != null && claz.length() > 0) {
            try {
                o = Class.forName(claz).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                String err = "The specified class for ResourceCache (" + claz + ") does not exist (or is not accessible to the current classlaoder).";
                this.rsvc.error(err);
                o = null;
            }
            if (!(o instanceof ResourceCache)) {
                String err = "The specified class for ResourceCache (" + claz + ") does not implement org.apache.runtime.resource.ResourceCache." + " ResourceManager. Using default ResourceCache implementation.";
                this.rsvc.error(err);
                o = null;
            }
        }
        if (o == null) {
            o = new ResourceCacheImpl();
        }
        this.globalCache = (ResourceCache)o;
        this.globalCache.initialize(this.rsvc);
        this.rsvc.info("Default ResourceManager initialization complete.");
    }

    private void assembleResourceLoaderInitializers() {
        if (this.resourceLoaderInitializersActive) {
            return;
        }
        Vector resourceLoaderNames = this.rsvc.getConfiguration().getVector("resource.loader");
        int i = 0;
        while (i < resourceLoaderNames.size()) {
            String loaderID = resourceLoaderNames.get(i) + "." + "resource.loader";
            ExtendedProperties loaderConfiguration = this.rsvc.getConfiguration().subset(loaderID);
            if (loaderConfiguration == null) {
                this.rsvc.warn("ResourceManager : No configuration information for resource loader named '" + resourceLoaderNames.get(i) + "'. Skipping.");
            } else {
                loaderConfiguration.setProperty(RESOURCE_LOADER_IDENTIFIER, resourceLoaderNames.get(i));
                this.sourceInitializerList.add(loaderConfiguration);
            }
            ++i;
        }
        this.resourceLoaderInitializersActive = true;
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = this.globalCache.get(resourceName);
        if (resource != null) {
            try {
                this.refreshResource(resource, encoding);
            }
            catch (ResourceNotFoundException rnfe) {
                this.globalCache.remove(resourceName);
                return this.getResource(resourceName, resourceType, encoding);
            }
            catch (ParseErrorException pee) {
                this.rsvc.error("ResourceManager.getResource() exception: " + pee);
                throw pee;
            }
            catch (Exception eee) {
                this.rsvc.error("ResourceManager.getResource() exception: " + eee);
                throw eee;
            }
        }
        try {
            resource = this.loadResource(resourceName, resourceType, encoding);
            if (resource.getResourceLoader().isCachingOn()) {
                this.globalCache.put(resourceName, resource);
            }
        }
        catch (ResourceNotFoundException rnfe2) {
            this.rsvc.error("ResourceManager : unable to find resource '" + resourceName + "' in any resource loader.");
            throw rnfe2;
        }
        catch (ParseErrorException pee) {
            this.rsvc.error("ResourceManager.getResource() parse exception: " + pee);
            throw pee;
        }
        catch (Exception ee) {
            this.rsvc.error("ResourceManager.getResource() exception new: " + ee);
            throw ee;
        }
        return resource;
    }

    protected Resource loadResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        Resource resource = ResourceFactory.getResource(resourceName, resourceType);
        resource.setRuntimeServices(this.rsvc);
        resource.setName(resourceName);
        resource.setEncoding(encoding);
        long howOldItWas = 0L;
        ResourceLoader resourceLoader = null;
        int i = 0;
        while (i < this.resourceLoaders.size()) {
            resourceLoader = (ResourceLoader)this.resourceLoaders.get(i);
            resource.setResourceLoader(resourceLoader);
            try {
                if (resource.process()) {
                    if (this.logWhenFound) {
                        this.rsvc.info("ResourceManager : found " + resourceName + " with loader " + resourceLoader.getClassName());
                    }
                    howOldItWas = resourceLoader.getLastModified(resource);
                    break;
                }
            }
            catch (ResourceNotFoundException rnfe) {
                // empty catch block
            }
            ++i;
        }
        if (resource.getData() == null) {
            throw new ResourceNotFoundException("Unable to find resource '" + resourceName + "'");
        }
        resource.setLastModified(howOldItWas);
        resource.setModificationCheckInterval(resourceLoader.getModificationCheckInterval());
        resource.touch();
        return resource;
    }

    protected void refreshResource(Resource resource, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        if (resource.requiresChecking()) {
            resource.touch();
            if (resource.isSourceModified()) {
                if (!resource.getEncoding().equals(encoding)) {
                    this.rsvc.error("Declared encoding for template '" + resource.getName() + "' is different on reload.  Old = '" + resource.getEncoding() + "'  New = '" + encoding);
                    resource.setEncoding(encoding);
                }
                long howOldItWas = resource.getResourceLoader().getLastModified(resource);
                resource.process();
                resource.setLastModified(howOldItWas);
            }
        }
    }

    public Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getResource(resourceName, resourceType, "ISO-8859-1");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLoaderNameForResource(String resourceName) {
        resourceLoader = null;
        i = 0;
        while (true) {
            block15: {
                block13: {
                    if (i >= this.resourceLoaders.size()) {
                        return null;
                    }
                    resourceLoader = (ResourceLoader)this.resourceLoaders.get(i);
                    is = null;
                    try {
                        try {
                            is = resourceLoader.getResourceStream(resourceName);
                            if (is == null) break block13;
                            var5_6 = resourceLoader.getClass().toString();
                            var7_7 = null;
                            if (is == null) return var5_6;
                        }
                        catch (ResourceNotFoundException e) {
                            var7_7 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException ioe) {}
                            }
                            break block15;
                        }
                    }
                    catch (Throwable var6_9) {
                        var7_7 = null;
                        if (is == null) throw var6_9;
                        ** try [egrp 2[TRYBLOCK] [2 : 78->86)] { 
lbl31:
                        // 1 sources

                        is.close();
                        throw var6_9;
lbl33:
                        // 1 sources

                        catch (IOException ioe) {
                            // empty catch block
                        }
                        throw var6_9;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 78->86)] { 
lbl38:
                    // 1 sources

                    is.close();
                    return var5_6;
lbl40:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    return var5_6;
                }
                var7_7 = null;
                if (is != null) {
                    try {}
                    catch (IOException ioe) {}
                    is.close();
                }
            }
            ++i;
        }
    }
}

