/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.ow2.jonas.ant.EJBDeploymentTool;
import org.ow2.jonas.ant.GenericDeploymentTool;
import org.ow2.jonas.ant.JonasDeploymentTool;
import org.xml.sax.SAXException;

public class EjbJar
extends MatchingTask {
    private Config config = new Config();
    private File destDir;
    private String genericJarSuffix = "-generic.jar";
    private String cmpVersion = "1.0";
    private ArrayList deploymentTools = new ArrayList();

    protected void addDeploymentTool(EJBDeploymentTool deploymentTool) {
        deploymentTool.setTask(this);
        this.deploymentTools.add(deploymentTool);
    }

    public JonasDeploymentTool createJonas() {
        this.log("JOnAS deployment tools", 3);
        JonasDeploymentTool tool = new JonasDeploymentTool();
        this.addDeploymentTool(tool);
        return tool;
    }

    public Path createClasspath() {
        if (this.config.classpath == null) {
            this.config.classpath = new Path(this.getProject());
        }
        return this.config.classpath.createPath();
    }

    public DTDLocation createDTD() {
        DTDLocation dtdLocation = new DTDLocation();
        this.config.dtdLocations.add(dtdLocation);
        return dtdLocation;
    }

    public FileSet createSupport() {
        FileSet supportFileSet = new FileSet();
        this.config.supportFileSets.add(supportFileSet);
        return supportFileSet;
    }

    public void setManifest(File manifest) {
        this.config.manifest = manifest;
    }

    public void setSrcdir(File inDir) {
        this.config.srcDir = inDir;
    }

    public void setDescriptordir(File inDir) {
        this.config.descriptorDir = inDir;
    }

    public void setDependency(String analyzer) {
        this.config.analyzer = analyzer;
    }

    public void setBasejarname(String inValue) {
        this.config.baseJarName = inValue;
        if (this.config.namingScheme == null) {
            this.config.namingScheme = new NamingScheme();
            this.config.namingScheme.setValue("basejarname");
        } else if (!this.config.namingScheme.getValue().equals("basejarname")) {
            throw new BuildException("The basejarname attribute is not compatible with the " + this.config.namingScheme.getValue() + " naming scheme");
        }
    }

    public void setNaming(NamingScheme namingScheme) {
        this.config.namingScheme = namingScheme;
        if (!this.config.namingScheme.getValue().equals("basejarname") && this.config.baseJarName != null) {
            throw new BuildException("The basejarname attribute is not compatible with the " + this.config.namingScheme.getValue() + " naming scheme");
        }
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File inDir) {
        this.destDir = inDir;
    }

    public String getCmpversion() {
        return this.cmpVersion;
    }

    public void setCmpversion(CMPVersion version) {
        this.cmpVersion = version.getValue();
    }

    public void setClasspath(Path classpath) {
        this.config.classpath = classpath;
    }

    public void setFlatdestdir(boolean inValue) {
        this.config.flatDestDir = inValue;
    }

    public void setGenericjarsuffix(String inString) {
        this.genericJarSuffix = inString;
    }

    public void setBasenameterminator(String inValue) {
        this.config.baseNameTerminator = inValue;
    }

    private void validateConfig() throws BuildException {
        if (this.config.srcDir == null) {
            throw new BuildException("The srcDir attribute must be specified");
        }
        if (this.config.descriptorDir == null) {
            this.config.descriptorDir = this.config.srcDir;
        }
        if (this.config.namingScheme == null) {
            this.config.namingScheme = new NamingScheme();
            this.config.namingScheme.setValue("descriptor");
        } else if (this.config.namingScheme.getValue().equals("basejarname") && this.config.baseJarName == null) {
            throw new BuildException("The basejarname attribute must be specified with the basejarname naming scheme");
        }
    }

    public void execute() throws BuildException {
        String msg;
        this.validateConfig();
        if (this.deploymentTools.size() == 0) {
            GenericDeploymentTool genericTool = new GenericDeploymentTool();
            genericTool.setTask(this);
            genericTool.setDestdir(this.destDir);
            genericTool.setGenericJarSuffix(this.genericJarSuffix);
            this.deploymentTools.add(genericTool);
        }
        Iterator i = this.deploymentTools.iterator();
        while (i.hasNext()) {
            EJBDeploymentTool tool = (EJBDeploymentTool)i.next();
            tool.configure(this.config);
            tool.validateConfigured();
        }
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(true);
            saxParserFactory.setNamespaceAware(true);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            DirectoryScanner ds = this.getDirectoryScanner(this.config.descriptorDir);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            this.log(files.length + " deployment descriptors located.", 3);
            for (int index = 0; index < files.length; ++index) {
                Iterator i2 = this.deploymentTools.iterator();
                while (i2.hasNext()) {
                    EJBDeploymentTool tool = (EJBDeploymentTool)i2.next();
                    tool.processDescriptor(files[index], saxParser);
                }
            }
        }
        catch (SAXException se) {
            msg = "SAXException while creating parser.  Details: " + se.getMessage();
            throw new BuildException(msg, se);
        }
        catch (ParserConfigurationException pce) {
            msg = "ParserConfigurationException while creating parser. Details: " + pce.getMessage();
            throw new BuildException(msg, pce);
        }
    }

    public static class CMPVersion
    extends EnumeratedAttribute {
        public static final String CMP1_0 = "1.0";
        public static final String CMP2_0 = "2.0";

        public String[] getValues() {
            return new String[]{CMP1_0, CMP2_0};
        }
    }

    public static class NamingScheme
    extends EnumeratedAttribute {
        public static final String EJB_NAME = "ejb-name";
        public static final String DIRECTORY = "directory";
        public static final String DESCRIPTOR = "descriptor";
        public static final String BASEJARNAME = "basejarname";

        public String[] getValues() {
            return new String[]{EJB_NAME, DIRECTORY, DESCRIPTOR, BASEJARNAME};
        }
    }

    static class Config {
        public File srcDir;
        public File descriptorDir;
        public String baseNameTerminator = "-";
        public String baseJarName;
        public boolean flatDestDir = false;
        public Path classpath;
        public List supportFileSets = new ArrayList();
        public ArrayList dtdLocations = new ArrayList();
        public NamingScheme namingScheme;
        public File manifest;
        public String analyzer;

        Config() {
        }
    }

    public static class DTDLocation
    extends org.apache.tools.ant.types.DTDLocation {
    }
}

