/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.ow2.jonas.ant.BootstrapTask;

public class GenICTask
extends BootstrapTask {
    private static final String GENIC_CLASS = "org.ow2.jonas.generators.genic.GenIC";
    private boolean validation = true;
    private String javac = null;
    private String javacOpts = null;
    private boolean keepGen = false;
    private boolean noFastRMIC = false;
    private String protocols = null;
    private boolean nocompil = false;
    private boolean invokeCmd = false;
    private String rmicOpts = null;
    private String additionalArgs = null;
    private boolean verbose = false;
    private Path libraryClasspath = null;
    private List<FileSet> filesets = new ArrayList();
    private boolean debug = false;

    public Path createClasspath() {
        this.libraryClasspath = new Path(this.getProject());
        return this.libraryClasspath;
    }

    public FileSet createFileSet() {
        FileSet set = new FileSet();
        set.setProject(this.getProject());
        this.filesets.add((Object)set);
        return set;
    }

    public void setAdditionalargs(String added) {
        this.additionalArgs = added;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    public void setJvmdebug(boolean d) {
        this.debug = d;
    }

    public void setInvokecmd(boolean inv) {
        this.invokeCmd = inv;
    }

    public void setNocompil(boolean noc) {
        this.nocompil = noc;
    }

    public void setRmicopts(String opts) {
        this.rmicOpts = opts;
    }

    public void setValidation(boolean v) {
        this.validation = v;
    }

    public void setJavac(String j) {
        this.javac = j;
    }

    public void setJavacopts(String opts) {
        this.javacOpts = opts;
    }

    public void setKeepgenerated(boolean k) {
        this.keepGen = k;
    }

    public void setNoFastRMIC(boolean value) {
        this.noFastRMIC = value;
    }

    public void setProtocols(String p) {
        this.protocols = p;
    }

    public void execute() throws BuildException {
        this.setServerName(null);
        Iterator fsIterator = this.filesets.iterator();
        while (fsIterator.hasNext()) {
            FileSet set = (FileSet)fsIterator.next();
            DirectoryScanner ds = set.getDirectoryScanner(this.getProject());
            ds.scan();
            String[] files = ds.getIncludedFiles();
            File srcDirectory = set.getDir(this.getProject());
            for (int i = 0; i < files.length; ++i) {
                Java genic = this.getBootstraptask(GENIC_CLASS);
                this.configureGenIC(genic, srcDirectory + File.separator + files[i]);
                this.log("Calling  GenIC task for '" + srcDirectory + File.separator + files[i] + "'.", 3);
                if (genic.executeJava() == 0) continue;
                throw new BuildException("GenIC reported an error.");
            }
        }
    }

    private Java configureGenIC(Java genicJavaTask, String filename) throws BuildException {
        if (this.keepGen) {
            genicJavaTask.createArg().setValue("-keepgenerated");
        }
        if (this.noFastRMIC) {
            genicJavaTask.createArg().setValue("-nofastrmic");
        }
        if (!this.validation) {
            genicJavaTask.createArg().setValue("-novalidation");
        }
        if (this.libraryClasspath != null) {
            genicJavaTask.createArg().setValue("-classpath");
            genicJavaTask.createArg().setPath(this.libraryClasspath);
        }
        if (this.nocompil) {
            genicJavaTask.createArg().setValue("-nocompil");
        }
        if (this.invokeCmd) {
            genicJavaTask.createArg().setValue("-invokecmd");
        }
        if (this.javac != null) {
            genicJavaTask.createArg().setValue("-javac");
            genicJavaTask.createArg().setLine(this.javac);
        }
        if (this.javacOpts != null && !this.javacOpts.equals("")) {
            genicJavaTask.createArg().setValue("-javacopts");
            genicJavaTask.createArg().setLine(this.javacOpts);
        }
        if (this.rmicOpts != null && !this.rmicOpts.equals("")) {
            genicJavaTask.createArg().setValue("-rmicopts");
            genicJavaTask.createArg().setValue(this.rmicOpts);
        }
        if (this.verbose) {
            genicJavaTask.createArg().setValue("-verbose");
        }
        if (this.debug) {
            this.log("Launching in debug mode on port 12345, waiting for connection ...", 2);
            genicJavaTask.createJvmarg().setLine("-Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,server=y,address=12345,suspend=y");
        }
        if (this.additionalArgs != null) {
            genicJavaTask.createArg().setLine(this.additionalArgs);
        }
        if (this.protocols != null) {
            genicJavaTask.createArg().setValue("-protocols");
            genicJavaTask.createArg().setValue(this.protocols);
        }
        genicJavaTask.createArg().setValue(filename);
        return genicJavaTask;
    }
}

