/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.cluster;

import java.io.File;
import java.util.Iterator;
import org.ow2.jonas.ant.cluster.ClusterTasks;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.Jms;

public class JmsCluster
extends ClusterTasks {
    private static final String INFO = "[JmsCluster] ";
    private String[] portRange = null;
    private String initialTopics = null;
    private String initialQueues = null;

    public void setPortRange(String portRange) {
        this.portRange = portRange.split(",");
    }

    public void setInitialTopics(String initialTopics) {
        this.initialTopics = initialTopics;
    }

    public void setInitialQueues(String initialQueues) {
        this.initialQueues = initialQueues;
    }

    public void generatesTasks() {
        int portInd = 0;
        for (int i = this.getDestDirSuffixIndFirst(); i <= this.getDestDirSuffixIndLast(); ++i) {
            String destDir = JmsCluster.getDestDir(this.getDestDirPrefix(), i);
            this.log("[JmsCluster] tasks generation for " + destDir);
            Jms jms = new Jms();
            jms.setPort(this.portRange[portInd]);
            jms.setInitialQueues(this.initialQueues);
            jms.setInitialTopics(this.initialTopics);
            Iterator it = jms.getTasks().iterator();
            while (it.hasNext()) {
                BaseTaskItf task = (BaseTaskItf)it.next();
                task.setDestDir(new File(destDir));
            }
            this.addTasks(jms);
            ++portInd;
        }
    }
}

