/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ant.jonasbase;

import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.ow2.jonas.ant.JOnASAntTool;
import org.ow2.jonas.ant.jonasbase.BaseTaskItf;
import org.ow2.jonas.ant.jonasbase.JTask;
import org.ow2.jonas.ant.jonasbase.Replace;

public class JmsRa
extends JTask
implements BaseTaskItf {
    private static final String INFO = "[JmsRa] ";
    private static final String JORAM_RA_FOR_JONAS = "joram_ra_for_jonas";
    private static final String RACONFIG_CLASS = "org.ow2.jonas.generators.raconfig.RAConfig";
    private static final String DEFAULT_PORT = "16010";
    private String serverPort = "16010";

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void execute() {
        File tmpFile = new File(System.getProperty("java.io.tmpdir"), String.valueOf(new Date().getTime()));
        String rarFileName = "joram_ra_for_jonas-" + this.getJoramVersion() + ".rar";
        String rarDir = this.getMaven2Repository() + File.separator + "org" + File.separator + "objectweb" + File.separator + "joram" + File.separator + JORAM_RA_FOR_JONAS + File.separator + this.getJoramVersion();
        String srcRarPathName = this.getJonasRoot().getPath() + File.separator + rarDir + File.separator + rarFileName;
        String dstRarPathName = this.getDestDir().getPath() + File.separator + rarDir + File.separator + rarFileName;
        Copy copy = new Copy();
        JOnASAntTool.configure(this, copy);
        copy.setTofile(new File(dstRarPathName));
        copy.setFile(new File(srcRarPathName));
        copy.setOverwrite(true);
        try {
            copy.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot copy joram_ra_for_jonas file : ", rae);
        }
        Expand jarTask = new Expand();
        JOnASAntTool.configure(this, jarTask);
        jarTask.setDest(tmpFile);
        jarTask.setSrc(new File(dstRarPathName));
        try {
            jarTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot extract jonas-ra.xml with jar command : ", rae);
        }
        Replace replaceTask = new Replace();
        JOnASAntTool.configure(this, replaceTask);
        replaceTask.setFile(new File(tmpFile.getPath() + File.separator + "META-INF/jonas-ra.xml"));
        String token = "<jonas-config-property-name>ServerPort</jonas-config-property-name>\n    <jonas-config-property-value></jonas-config-property-value>";
        String value = "<jonas-config-property-name>ServerPort</jonas-config-property-name>\n    <jonas-config-property-value>" + this.serverPort + "</jonas-config-property-value>";
        replaceTask.setToken(token);
        replaceTask.setValue(value);
        try {
            replaceTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            JOnASAntTool.deleteAllFiles(tmpFile);
            throw new BuildException("[JmsRa] Cannot replace port number in the jonas-ra.xml file : ", rae);
        }
        Java raConfigTask = this.getBootstraptask("", false);
        String clientJar = this.getJonasRoot().getPath() + File.separator + "lib" + File.separator + "client.jar";
        String raConfigJar = this.getJonasRoot().getPath() + File.separator + "lib" + File.separator + "jonas-generators-raconfig.jar";
        Path classpath = new Path(raConfigTask.getProject(), clientJar);
        classpath.append(new Path(raConfigTask.getProject(), raConfigJar));
        raConfigTask.setClasspath(classpath);
        JOnASAntTool.configure(this, raConfigTask);
        raConfigTask.clearArgs();
        raConfigTask.createArg().setValue(RACONFIG_CLASS);
        raConfigTask.createArg().setValue("-u");
        raConfigTask.createArg().setValue(tmpFile.getPath() + File.separator + "META-INF/jonas-ra.xml");
        raConfigTask.createArg().setValue(dstRarPathName);
        try {
            raConfigTask.execute();
        }
        catch (Exception rae) {
            rae.printStackTrace();
            throw new BuildException("[JmsRa] Cannot make a resource adaptor on RAConfig: ", rae);
        }
        finally {
            JOnASAntTool.deleteAllFiles(tmpFile);
        }
        this.log("[JmsRa] Setting Port number to :" + this.serverPort + " in the rar '" + dstRarPathName + "'.");
    }

    private String getJoramVersion() {
        Properties versions = new Properties();
        try {
            versions.load(new FileInputStream(new File(this.getJonasRoot(), "versions.properties")));
        }
        catch (Exception e) {
            throw new BuildException("[JmsRa] Cannot read versions.properties file: ", e);
        }
        return versions.getProperty("org.objectweb.joram");
    }
}

