/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.domain.wrapper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ow2.jonas.deployment.domain.DomainMap;
import org.ow2.jonas.deployment.domain.DomainMapException;
import org.ow2.jonas.lib.bootstrap.LoaderManager;
import org.ow2.jonas.lib.bootstrap.loader.JClassLoader;

public class DomainManagerWrapper {
    private static final String DOMAIN_MANAGER_CLASSNAME = "org.ow2.jonas.deployment.domain.lib.DomainMapManager";

    private DomainManagerWrapper() {
    }

    public static DomainMap getDomainMap(String domainFileName, ClassLoader cl) throws DomainMapException {
        LoaderManager lm = LoaderManager.getInstance();
        DomainMap map = null;
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(DOMAIN_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("getDomainMap", new Class[]{String.class, ClassLoader.class});
            map = (DomainMap)m.invoke(null, new Object[]{domainFileName, cl});
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (DomainMapException.class.isInstance((Object)t)) {
                throw (DomainMapException)ite.getTargetException();
            }
            throw new DomainMapException("DomainMapManager.getDomainMap fails", t);
        }
        catch (Exception e) {
            throw new DomainMapException("Problems when using reflection on DomainMapManager", e);
        }
        return map;
    }

    public static void setParsingWithValidation(boolean b) {
        LoaderManager lm = LoaderManager.getInstance();
        try {
            JClassLoader ext = lm.getExternalLoader();
            Class manager = ext.loadClass(DOMAIN_MANAGER_CLASSNAME);
            Method m = manager.getDeclaredMethod("setParsingWithValidation", new Class[]{Boolean.TYPE});
            m.invoke(null, new Object[]{new Boolean(b)});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

