/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.api.IJNDIEnvRefsGroupDesc;
import org.ow2.jonas.deployment.api.IServiceRefDesc;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.EjbLocalRefDesc;
import org.ow2.jonas.deployment.common.EjbRefDesc;
import org.ow2.jonas.deployment.common.MessageDestinationRefDesc;
import org.ow2.jonas.deployment.common.digester.JDigester;
import org.ow2.jonas.deployment.common.lib.AbsDeploymentDescManager;
import org.ow2.jonas.deployment.common.xml.JonasMessageDestination;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDesc;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb1_1;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EjbjarDTDs;
import org.ow2.jonas.deployment.ejb.EjbjarSchemas;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.JonasEjbjarDTDs;
import org.ow2.jonas.deployment.ejb.JonasEjbjarSchemas;
import org.ow2.jonas.deployment.ejb.MessageDrivenDesc;
import org.ow2.jonas.deployment.ejb.SessionDesc;
import org.ow2.jonas.deployment.ejb.rules.EjbJarRuleSet;
import org.ow2.jonas.deployment.ejb.rules.JonasEjbJarRuleSet;
import org.ow2.jonas.deployment.ejb.xml.EjbJar;
import org.ow2.jonas.deployment.ejb.xml.JonasEjbJar;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentRefDesc;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.lib.WSDeploymentDescManager;
import org.ow2.jonas.lib.util.BeanNaming;
import org.ow2.jonas.lib.util.Log;
import org.ow2.util.url.URLUtils;

public class EjbDeploymentDescManager
extends AbsDeploymentDescManager {
    public static final String EJB_JAR_FILE_NAME = "META-INF/ejb-jar.xml";
    public static final String JONAS_EJB_JAR_FILE_NAME = "META-INF/jonas-ejb-jar.xml";
    private static boolean parsingWithValidation = true;
    private static EjbDeploymentDescManager unique;
    private static JDigester ejbjarDigester;
    private static JDigester jonasEjbjarDigester;
    private static EjbJarRuleSet ejbjarRuleSet;
    private static JonasEjbJarRuleSet jonasEjbjarRuleSet;
    private WSDeploymentDescManager wsDDManager = null;
    private Hashtable urlJarBindings = new Hashtable();
    private Hashtable urlEarCLBindings = new Hashtable();
    private Hashtable urlEjbCLBindings = new Hashtable();
    private Hashtable urlAltDDBindings = null;
    private Hashtable earCLEjbLinkJar = new Hashtable();
    private static Logger logger;
    private static Hashtable staticCache;
    private static String xmlContent;
    private static String jonasXmlContent;

    private EjbDeploymentDescManager() {
        this.urlAltDDBindings = new Hashtable();
    }

    public static EjbDeploymentDescManager getInstance() {
        if (unique == null) {
            unique = new EjbDeploymentDescManager();
        }
        return unique;
    }

    public static DeploymentDesc getDeploymentDesc(String ejbjar, ClassLoader ejbLoader) throws DeploymentDescException {
        if (!staticCache.containsKey(ejbjar)) {
            return EjbDeploymentDescManager.getDeploymentDescriptor(ejbjar, ejbLoader, null);
        }
        return (DeploymentDesc)staticCache.get(ejbjar);
    }

    public synchronized DeploymentDesc getDeploymentDesc(URL url, ClassLoader ejbLoader, ClassLoader earLoader) throws DeploymentDescException {
        String ddPath;
        DeploymentDesc dd;
        if (this.wsDDManager == null) {
            this.wsDDManager = WSDeploymentDescManager.getInstance();
        }
        if (earLoader != null) {
            this.checkEjbLinkAvailable(earLoader, url);
        }
        if ((dd = (DeploymentDesc)this.urlJarBindings.get(ddPath = URLUtils.urlToFile(url).getPath())) == null) {
            dd = this.loadDeploymentDesc(url, ejbLoader, earLoader);
        }
        return dd;
    }

    private DeploymentDesc getDeploymentDesc(URL currentUrl, URL urlToLoad) throws DeploymentDescException {
        DeploymentDesc ejbLinkDD = (DeploymentDesc)this.urlJarBindings.get(URLUtils.urlToFile(urlToLoad).getPath());
        if (ejbLinkDD == null) {
            String url = URLUtils.urlToFile(currentUrl).getPath();
            URLClassLoader earLoader = (URLClassLoader)this.urlEarCLBindings.get(url);
            if (!URLUtils.urlToFile(urlToLoad).exists()) {
                throw new DeploymentDescException("There is an ejb-link from the '" + currentUrl + "' URL to the '" + urlToLoad + "' URL but the last file does not exist. Check ejb-link in the first file");
            }
            if (new File(url).isFile() && !url.toLowerCase().endsWith(".jar")) {
                String err = "File '" + url + "' is not a jar file";
                throw new DeploymentDescException(err);
            }
            if (earLoader != null) {
                this.checkEjbLinkAvailable(earLoader, urlToLoad);
                URLClassLoader loaderForCls = (URLClassLoader)this.urlEjbCLBindings.get(url);
                if (loaderForCls == null) {
                    loaderForCls = new URLClassLoader(new URL[]{urlToLoad});
                }
                URLClassLoader loader = (URLClassLoader)this.urlEarCLBindings.get(url);
                ejbLinkDD = this.loadDeploymentDesc(urlToLoad, loaderForCls, loader);
            } else if (!currentUrl.getFile().equals(urlToLoad)) {
                String err = "In '" + url + "' ejb-link is not allowed outside the ejb-jar if you are not in an ear application.";
                throw new DeploymentDescException(err);
            }
        }
        return ejbLinkDD;
    }

    private DeploymentDesc loadDeploymentDesc(URL url, ClassLoader ejbLoader, ClassLoader earLoader) throws DeploymentDescException {
        File f = URLUtils.urlToFile(url);
        String filename = f.getPath();
        if (!f.exists()) {
            throw new DeploymentDescException(filename + " not found");
        }
        DeploymentDesc dd = null;
        if (f.isDirectory()) {
            dd = EjbDeploymentDescManager.getDeploymentDescriptor(filename + EJB_JAR_FILE_NAME, BeanNaming.getJonasXmlName(filename + EJB_JAR_FILE_NAME), ejbLoader, f.getAbsolutePath());
        } else if (filename.toLowerCase().endsWith(".xml")) {
            File parent = f.getParentFile();
            dd = EjbDeploymentDescManager.getDeploymentDescriptor(filename, BeanNaming.getJonasXmlName(filename), ejbLoader, parent.getAbsolutePath());
        } else {
            String altname = null;
            URL altDDUrl = (URL)this.urlAltDDBindings.get(URLUtils.urlToFile(url).getPath());
            if (altDDUrl != null) {
                altname = URLUtils.urlToFile(altDDUrl).getPath();
            }
            dd = EjbDeploymentDescManager.getDeploymentDescriptor(filename, ejbLoader, altname);
        }
        if (earLoader != null) {
            this.urlEjbCLBindings.put(filename, ejbLoader);
            this.urlEarCLBindings.put(filename, earLoader);
        }
        BeanDesc[] bd = dd.getBeanDesc();
        for (int j = 0; j < bd.length; ++j) {
            String ejbName;
            String ejbRefType;
            EjbRefDesc[] ejbRef = bd[j].getEjbRefDesc();
            for (int i = 0; i < ejbRef.length; ++i) {
                String jndiName = ejbRef[i].getJndiName();
                String ejbLink = ejbRef[i].getEjbLink();
                ejbRefType = ejbRef[i].getEjbRefType();
                if (ejbLink == null || jndiName != null) continue;
                ejbName = this.getJndiName(url, ejbLink, earLoader, ejbRefType, dd, true);
                ejbRef[i].setJndiName(ejbName);
            }
            EjbLocalRefDesc[] ejbLocalRef = bd[j].getEjbLocalRefDesc();
            for (int i = 0; i < ejbLocalRef.length; ++i) {
                String ejblink = ejbLocalRef[i].getEjbLink();
                if (ejblink == null) {
                    String err = "Ejb-link must be specified for ejb-local-ref " + ejbLocalRef[i].getEjbRefName();
                    throw new DeploymentDescException(err);
                }
                ejbRefType = ejbLocalRef[i].getEjbRefType();
                ejbName = this.getJndiName(url, ejblink, earLoader, ejbRefType, dd, false);
                ejbLocalRef[i].setJndiLocalName(ejbName);
            }
            IServiceRefDesc[] serviceRef = bd[j].getServiceRefDesc();
            for (int i = 0; i < serviceRef.length; ++i) {
                List pcRefs = serviceRef[i].getPortComponentRefs();
                for (int k = 0; k < pcRefs.size(); ++k) {
                    PortComponentRefDesc pcr = (PortComponentRefDesc)pcRefs.get(k);
                    String pclink = pcr.getPortComponentLink();
                    if (pclink == null) continue;
                    PortComponentDesc pcDesc = this.getPCDesc(url, pclink, ejbLoader, earLoader);
                    pcr.setPortComponentDesc(pcDesc);
                }
            }
            MessageDestinationRefDesc[] mdRef = bd[j].getMessageDestinationRefDesc();
            for (int i = 0; i < mdRef.length; ++i) {
                String jndiName = mdRef[i].getJndiName();
                String mdLink = mdRef[i].getMessageDestinationLink();
                String mdType = mdRef[i].getMessageDestinationType();
                String mdUsage = mdRef[i].getMessageDestinationUsage();
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("" + jndiName + " " + mdLink + " " + mdType + " " + mdUsage));
                }
                if (mdLink == null || jndiName != null) continue;
                String mdName = this.getMDJndiName(url, mdLink, mdType, mdUsage, dd);
                mdRef[i].setJndiName(mdName);
            }
        }
        if (earLoader != null) {
            this.urlJarBindings.put(filename, dd);
        }
        return dd;
    }

    private PortComponentDesc getPCDesc(URL ejbjarURL, String pcLink, ClassLoader moduleLoader, ClassLoader earLoader) throws WSDeploymentDescException {
        return this.wsDDManager.getPortComponentDesc(ejbjarURL, pcLink, moduleLoader, earLoader);
    }

    public String getJndiName(URL currentFile, String ejbLink, ClassLoader earCl, String ejbType, DeploymentDesc deploymentDesc, boolean isEjbRef) throws DeploymentDescException {
        StringTokenizer st;
        String ejbJarLink = null;
        String beanNameLink = null;
        if (ejbLink.indexOf("#") == -1) {
            BeanDesc bd = null;
            if (earCl == null && deploymentDesc == null) {
                throw new DeploymentDescException("Deployment desc for file ejb-jar '" + currentFile + "' not found");
            }
            if (deploymentDesc != null) {
                bd = deploymentDesc.getBeanDesc(ejbLink);
            }
            String url = URLUtils.urlToFile(currentFile).getPath();
            URLClassLoader earClassLoader = null;
            URLClassLoader ejbLoader = (URLClassLoader)this.urlEjbCLBindings.get(url);
            if (earCl != null) {
                earClassLoader = (URLClassLoader)earCl;
                this.urlEarCLBindings.put(url, earCl);
            } else {
                earClassLoader = (URLClassLoader)this.urlEarCLBindings.get(url);
            }
            if (earClassLoader == null && bd == null) {
                String err = "Ejb-link " + ejbLink + " not found inside the file " + currentFile + ". The bean doesn't exists.";
                throw new DeploymentDescException(err);
            }
            if (bd == null) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("The bean '" + ejbLink + "' was not found in the current ejbjar, searching on all the ejbjars."));
                }
                Vector v = (Vector)this.earCLEjbLinkJar.get(earClassLoader);
                DeploymentDesc lookupDD = null;
                String fileName = null;
                URL urlRead = null;
                String urlReadString = null;
                boolean found = false;
                BeanDesc bdtmp = null;
                Enumeration e = v.elements();
                while (e.hasMoreElements()) {
                    urlReadString = (String)e.nextElement();
                    File f = new File(urlReadString);
                    urlRead = URLUtils.fileToURL(f);
                    if (ejbLoader == null) {
                        ejbLoader = (URLClassLoader)this.urlEjbCLBindings.get(f.getPath());
                    }
                    if (ejbLoader == null) {
                        throw new DeploymentDescException("Error while resolving ejb-link. The ejb classloader is not found for url '" + urlReadString + "'.");
                    }
                    this.urlEjbCLBindings.put(urlReadString, ejbLoader);
                    fileName = URLUtils.urlToFile(urlRead).getPath();
                    if (fileName.equals(url)) continue;
                    if (f.isDirectory()) {
                        lookupDD = EjbDeploymentDescManager.getDeploymentDescriptor(fileName + EJB_JAR_FILE_NAME, BeanNaming.getJonasXmlName(fileName + EJB_JAR_FILE_NAME), ejbLoader, f.getAbsolutePath());
                    } else if (fileName.toLowerCase().endsWith(".xml")) {
                        File parent = f.getParentFile().getParentFile();
                        lookupDD = EjbDeploymentDescManager.getDeploymentDescriptor(fileName, BeanNaming.getJonasXmlName(fileName), ejbLoader, parent.getAbsolutePath());
                    } else {
                        String altname = null;
                        URL altDDUrl = (URL)this.urlAltDDBindings.get(url);
                        if (altDDUrl != null) {
                            altname = URLUtils.urlToFile(altDDUrl).getPath();
                        }
                        lookupDD = EjbDeploymentDescManager.getDeploymentDescriptor(fileName, ejbLoader, altname);
                    }
                    if (lookupDD == null) continue;
                    bdtmp = lookupDD.getBeanDesc(ejbLink);
                    if (bdtmp != null) {
                        if (logger.isLoggable(BasicLevel.DEBUG)) {
                            logger.log(BasicLevel.DEBUG, (Object)("Found a BeanDesc in the Deployment Desc." + urlRead));
                        }
                        if (found) {
                            String err = "There are more than one bean with the name '" + ejbLink + "' which were found in all the ejbjars of this EAR.";
                            throw new DeploymentDescException(err);
                        }
                        found = true;
                        bd = bdtmp;
                        continue;
                    }
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)("No BeanDesc found in the Deployment Desc." + urlRead));
                }
                if (!found) {
                    String err = "No ejblink was found for '" + ejbLink + "' in all the ejbjars of this EAR.";
                    throw new DeploymentDescException(err);
                }
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)("BeanDesc found = " + bd.getEjbName()));
            }
            this.checkType(currentFile, ejbType, bd);
            if (bd == null) {
                String err = "Ejb-link " + ejbLink + " not found inside the file " + currentFile + ". The bean doesn't exists.";
                throw new DeploymentDescException(err);
            }
            String jndiname = isEjbRef ? bd.getJndiName() : bd.getJndiLocalName();
            return jndiname;
        }
        if (earCl != null) {
            this.urlEarCLBindings.put(URLUtils.urlToFile(currentFile).getPath(), earCl);
        }
        if ((st = new StringTokenizer(ejbLink, "#")).countTokens() != 2 || ejbLink.startsWith("#") || ejbLink.endsWith("#")) {
            String err = "Ejb link " + ejbLink + " has a bad format. Correct format :  filename.jar#beanName.";
            throw new DeploymentDescException(err);
        }
        ejbJarLink = st.nextToken();
        beanNameLink = st.nextToken();
        if (!ejbJarLink.endsWith(".jar")) {
            String err = "Ejbjar filename " + ejbJarLink + " from the ejb-link " + ejbLink + " has a bad format. Correct format :  filename.jar";
            throw new DeploymentDescException(err);
        }
        URL ejbJarLinkUrl = null;
        ejbJarLinkUrl = URLUtils.fileToURL(new File(URLUtils.urlToFile(currentFile).getParent() + File.separator + ejbJarLink));
        BeanDesc bd = null;
        if (currentFile.getPath().equalsIgnoreCase(ejbJarLinkUrl.getPath())) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"ejblink jar#bean reference our current file");
            }
            if (deploymentDesc != null) {
                bd = deploymentDesc.getBeanDesc(beanNameLink);
            } else if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"DD = null, cannot return bean in the current DD");
            }
        } else {
            DeploymentDesc dd = this.getDeploymentDesc(currentFile, ejbJarLinkUrl);
            bd = dd.getBeanDesc(beanNameLink);
        }
        if (bd == null) {
            String err = "Ejb-link " + ejbLink + " not found inside the file " + currentFile + ". The bean doesn't exists";
            throw new DeploymentDescException(err);
        }
        this.checkType(currentFile, ejbType, bd);
        String jndiname = isEjbRef ? bd.getJndiName() : bd.getJndiLocalName();
        return jndiname;
    }

    private String getMDJndiName(URL ejbJar, String mdLink, String mdType, String mdUsage, DeploymentDesc deploymentDesc) throws DeploymentDescException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("" + ejbJar + " " + mdLink + " " + mdType + " " + mdUsage));
        }
        String ejbJarLink = null;
        DeploymentDesc dd = deploymentDesc;
        if (mdLink.indexOf("#") != -1) {
            StringTokenizer st = new StringTokenizer(mdLink, "#");
            if (st.countTokens() != 2 || mdLink.startsWith("#") || mdLink.endsWith("#")) {
                String err = "Message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar#messageDestinationName.";
                throw new DeploymentDescException(err);
            }
            ejbJarLink = st.nextToken();
            if (!ejbJarLink.endsWith(".jar")) {
                String err = "Ejbjar filename " + ejbJarLink + " from the message-destination-link " + mdLink + " has a bad format. Correct format :  filename.jar";
                throw new DeploymentDescException(err);
            }
            URL ejbJarLinkUrl = null;
            try {
                ejbJarLinkUrl = URLUtils.fileToURL(new File(URLUtils.urlToFile(ejbJar).getParent() + File.separator + ejbJarLink).getCanonicalFile());
            }
            catch (IOException ioe) {
                String err = "Error when creating/accessing a file. Error :" + ioe.getMessage();
                throw new DeploymentDescException(err);
            }
            if (!URLUtils.urlToFile(ejbJarLinkUrl).exists()) {
                String err = "Cannot get the deployment descriptor for '" + ejbJarLinkUrl + "'. The file doesn't exist.";
                throw new DeploymentDescException(err);
            }
            dd = this.getDeploymentDesc(ejbJar, ejbJarLinkUrl);
        }
        if (dd == null) {
            throw new DeploymentDescException("Deployment desc for file ejb-jar '" + ejbJar + "' not found");
        }
        boolean foundMd = dd.getMessageDestination(mdLink);
        if (!foundMd) {
            String err = "No message-destination was found for '" + mdLink + "' in the ejbjar specified.";
            throw new DeploymentDescException(err);
        }
        JonasMessageDestination md = dd.getJonasMessageDestination(mdLink);
        if (md == null) {
            String err = "No jonas-message-destination was found for '" + mdLink + "' in the ejbjar specified.";
            throw new DeploymentDescException(err);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Message-destination found = " + md.getJndiName()));
        }
        return md.getJndiName();
    }

    private void checkEjbLinkAvailable(ClassLoader earClassLoader, URL url) throws DeploymentDescException {
        Vector v = (Vector)this.earCLEjbLinkJar.get(earClassLoader);
        if (v != null) {
            if (!v.contains(URLUtils.urlToFile(url).getPath())) {
                throw new DeploymentDescException("The ejb-link or message-destination-link of '" + url + "' must be done on an ejb-jar defined in the ear application " + "(application.xml <module><ejb>###</ejb></module>)");
            }
        } else {
            String err = "setAvailableEjbLinkJar was badly called.";
            throw new DeploymentDescException(err);
        }
    }

    public void setAvailableEjbJarsAndAltDDs(ClassLoader earClassLoader, URL[] urls, URL[] altDDs) {
        Vector v = new Vector();
        for (int i = 0; i < urls.length; ++i) {
            v.addElement(URLUtils.urlToFile(urls[i]).getPath());
            if (altDDs[i] == null) continue;
            this.urlAltDDBindings.put(URLUtils.urlToFile(urls[i]).getPath(), altDDs[i]);
        }
        this.earCLEjbLinkJar.put(earClassLoader, v);
    }

    public void removeCache(ClassLoader earClassLoader) {
        Vector v = (Vector)this.earCLEjbLinkJar.remove(earClassLoader);
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                String url = (String)v.elementAt(i);
                this.urlJarBindings.remove(url);
                this.urlEarCLBindings.remove(url);
                this.urlEjbCLBindings.remove(url);
                this.urlAltDDBindings.remove(url);
            }
        }
        if (this.earCLEjbLinkJar.size() != 0 || this.urlJarBindings.size() != 0 || this.urlEarCLBindings.size() != 0 || this.urlAltDDBindings.size() != 0 || this.urlEjbCLBindings.size() != 0) {
            String buffer = this.earCLEjbLinkJar.size() + " ";
            buffer = buffer + this.urlJarBindings.size() + " ";
            buffer = buffer + this.urlEarCLBindings.size() + " ";
            buffer = buffer + this.urlEjbCLBindings.size() + " ";
            buffer = buffer + this.urlAltDDBindings.size();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(buffer + " there are some elements in cache"));
            }
        }
    }

    public int getCacheSize() {
        return this.earCLEjbLinkJar.size() + this.urlJarBindings.size() + this.urlEarCLBindings.size() + this.urlEjbCLBindings.size() + this.urlAltDDBindings.size();
    }

    public String toString() {
        return this.earCLEjbLinkJar.size() + " " + this.urlJarBindings.size() + " " + this.urlEarCLBindings.size() + " " + this.urlEjbCLBindings.size() + " " + this.urlAltDDBindings.size();
    }

    public static DeploymentDesc getDeploymentDesc(String ejbJarXmlFileName, String jonasEjbJarXmlFileName, String jarFileName) throws DeploymentDescException {
        ClassLoader cl = DeploymentDesc.class.getClassLoader();
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        return EjbDeploymentDescManager.getDeploymentDescriptor(ejbJarXmlFileName, jonasEjbJarXmlFileName, cl, jarFileName);
    }

    private static DeploymentDesc getDeploymentDescriptor(String ejbJarXmlFileName, String jonasEjbJarXmlFileName, ClassLoader cl, String moduleDirName) throws DeploymentDescException {
        FileInputStream is;
        try {
            is = new FileInputStream(ejbJarXmlFileName);
            xmlContent = EjbDeploymentDescManager.xmlContent(is);
            is = new FileInputStream(ejbJarXmlFileName);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentDescException(ejbJarXmlFileName + " file not found");
        }
        catch (IOException ioe) {
            throw new DeploymentDescException("Cannot read the content of the xml file " + ejbJarXmlFileName);
        }
        EjbJar ejbJar = EjbDeploymentDescManager.loadEjbJar(new InputStreamReader(is), ejbJarXmlFileName);
        String dtdversion = ejbJar.getVersion();
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            logger.log(BasicLevel.WARN, (Object)("Can't close '" + ejbJarXmlFileName + "'"));
        }
        try {
            is = new FileInputStream(jonasEjbJarXmlFileName);
            jonasXmlContent = EjbDeploymentDescManager.xmlContent(is);
            is = new FileInputStream(jonasEjbJarXmlFileName);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentDescException(jonasEjbJarXmlFileName + " file not found");
        }
        catch (IOException ioe) {
            throw new DeploymentDescException("Cannot read the content of the xml file " + ejbJarXmlFileName);
        }
        JonasEjbJar jonasEjbJar = EjbDeploymentDescManager.loadJonasEjbJar(new InputStreamReader(is), jonasEjbJarXmlFileName);
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            logger.log(BasicLevel.WARN, (Object)("Can't close '" + jonasEjbJarXmlFileName + "'"));
        }
        DeploymentDesc descEjb = null;
        descEjb = dtdversion.equals("1.1") ? new DeploymentDescEjb1_1(cl, ejbJar, jonasEjbJar, logger, moduleDirName) : new DeploymentDescEjb2(cl, ejbJar, jonasEjbJar, logger, moduleDirName);
        descEjb.setXmlContent(xmlContent);
        descEjb.setJOnASXmlContent(jonasXmlContent);
        return descEjb;
    }

    private static DeploymentDesc getDeploymentDescriptor(String ejbJarFileName, ClassLoader cl, String altWebXmlFilename) throws DeploymentDescException {
        JonasEjbJar jonasEjbJar;
        EjbJar ejbJar;
        ZipFile zf = null;
        InputStream isDd = null;
        InputStream isJdd = null;
        if (altWebXmlFilename != null && !new File(altWebXmlFilename).exists()) {
            String err = "The file for the altdd tag for the EAR case '" + altWebXmlFilename + "' was not found.";
            throw new DeploymentDescException(err);
        }
        try {
            zf = new ZipFile(ejbJarFileName);
            if (altWebXmlFilename == null) {
                ZipEntry ejbEntry = zf.getEntry(EJB_JAR_FILE_NAME);
                if (ejbEntry != null) {
                    isDd = zf.getInputStream(ejbEntry);
                    xmlContent = EjbDeploymentDescManager.xmlContent(isDd);
                    isDd = zf.getInputStream(zf.getEntry(EJB_JAR_FILE_NAME));
                }
            } else {
                isDd = new FileInputStream(altWebXmlFilename);
                xmlContent = EjbDeploymentDescManager.xmlContent(isDd);
                isDd = new FileInputStream(altWebXmlFilename);
            }
            ZipEntry jEjbEntry = zf.getEntry(JONAS_EJB_JAR_FILE_NAME);
            if (jEjbEntry != null) {
                isJdd = zf.getInputStream(jEjbEntry);
                jonasXmlContent = EjbDeploymentDescManager.xmlContent(isJdd);
                isJdd = zf.getInputStream(zf.getEntry(JONAS_EJB_JAR_FILE_NAME));
            } else {
                logger.log(BasicLevel.WARN, (Object)("No entry 'META-INF/jonas-ejb-jar.xml' was found in the file '" + ejbJarFileName + "'."));
            }
        }
        catch (Exception e) {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException i) {
                    logger.log(BasicLevel.WARN, (Object)("Can't close '" + ejbJarFileName + "'"));
                }
            }
            logger.log(BasicLevel.ERROR, (Object)("Cannot read the XML deployment descriptors for " + ejbJarFileName + ":"), (Throwable)e);
            throw new DeploymentDescException("Cannot read the XML deployment descriptors for " + ejbJarFileName + ":" + e);
        }
        String dtdversion = null;
        if (isDd != null) {
            ejbJar = EjbDeploymentDescManager.loadEjbJar(new InputStreamReader(isDd), EJB_JAR_FILE_NAME);
            dtdversion = ejbJar.getVersion();
            try {
                isDd.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close META-INF/ejb-jar.xml in '" + ejbJarFileName + "'"));
            }
        } else {
            ejbJar = new EjbJar();
        }
        if (isJdd != null) {
            jonasEjbJar = EjbDeploymentDescManager.loadJonasEjbJar(new InputStreamReader(isJdd), JONAS_EJB_JAR_FILE_NAME);
            try {
                isJdd.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close META-INF/jonas-ejb-jar.xml in '" + ejbJarFileName + "'"));
            }
        } else {
            jonasEjbJar = new JonasEjbJar();
        }
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException e) {
                logger.log(BasicLevel.WARN, (Object)("Can't close '" + ejbJarFileName + "'"));
            }
        }
        DeploymentDesc descEjb = null;
        descEjb = "1.1".equals(dtdversion) ? new DeploymentDescEjb1_1(cl, ejbJar, jonasEjbJar, logger, ejbJarFileName) : new DeploymentDescEjb2(cl, ejbJar, jonasEjbJar, logger, ejbJarFileName);
        descEjb.setXmlContent(xmlContent);
        descEjb.setJOnASXmlContent(jonasXmlContent);
        return descEjb;
    }

    public static EjbJar loadEjbJar(Reader reader, String name) throws DeploymentDescException {
        EjbJar ejbjar = new EjbJar();
        if (ejbjarDigester == null) {
            ejbjarDigester = new JDigester(ejbjarRuleSet, parsingWithValidation, true, new EjbjarDTDs(), new EjbjarSchemas());
        }
        try {
            ejbjarDigester.parse(reader, name, ejbjar);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            ejbjarDigester.push(null);
        }
        return ejbjar;
    }

    public static JonasEjbJar loadJonasEjbJar(Reader reader, String name) throws DeploymentDescException {
        JonasEjbJar jonasEjbjar = new JonasEjbJar();
        if (jonasEjbjarDigester == null) {
            jonasEjbjarDigester = new JDigester(jonasEjbjarRuleSet, parsingWithValidation, true, new JonasEjbjarDTDs(), new JonasEjbjarSchemas());
        }
        try {
            jonasEjbjarDigester.parse(reader, name, jonasEjbjar);
        }
        catch (DeploymentDescException e) {
            throw e;
        }
        finally {
            jonasEjbjarDigester.push(null);
        }
        return jonasEjbjar;
    }

    public static boolean getParsingWithValidation() {
        return parsingWithValidation;
    }

    public static void setParsingWithValidation(boolean validation) {
        parsingWithValidation = validation;
    }

    public static String getXmlContent() {
        return xmlContent;
    }

    public static String getJOnASXmlContent() {
        return jonasXmlContent;
    }

    protected void checkType(URL ejbJar, String ejbType, IJNDIEnvRefsGroupDesc bd) throws DeploymentDescException {
        if (bd instanceof SessionDesc) {
            if (!ejbType.equalsIgnoreCase("Session")) {
                String err = "Deployment desc '" + ejbJar + "' has an incompatible ejb-ref-type: Required Session but found " + ejbType;
                throw new DeploymentDescException(err);
            }
        } else if (bd instanceof EntityDesc) {
            if (!ejbType.equalsIgnoreCase("Entity")) {
                String err = "Deployment desc '" + ejbJar + "' has an incompatible ejb-ref-type: Required Entity but found " + ejbType;
                throw new DeploymentDescException(err);
            }
        } else {
            String err = "Deployment desc '" + ejbJar + "' has a bad ejb-ref-type.";
            throw new DeploymentDescException(err);
        }
    }

    protected void checkTypeUsage(URL url, String mdType, String mdUsage, BeanDesc bd) throws DeploymentDescException {
        if (bd instanceof MessageDrivenDesc) {
            MessageDrivenDesc mdd = (MessageDrivenDesc)bd;
            if (mdd.getDestinationType().equals("javax.jms.Topic")) {
                if (!mdType.equalsIgnoreCase("javax.jms.Topic")) {
                    String err = "Deployment desc '" + url + "' has an incompatible message-destination-type: Required javax.jms.Topic but found " + mdType;
                    throw new DeploymentDescException(err);
                }
            } else if (mdd.getDestinationType().equals("javax.jms.Queue") && !mdType.equalsIgnoreCase("javax.jms.Queue")) {
                String err = "Deployment desc '" + url + "' has an incompatible message-destination-type: Required javax.jms.Queue but found " + mdType;
                throw new DeploymentDescException(err);
            }
        } else {
            String err = "Deployment desc '" + url + "' has a bad message-destination-ref-type.";
            throw new DeploymentDescException(err);
        }
    }

    public void addClassLoaderUrlMapping(ClassLoader ejbClassloader, URL[] urls) {
        for (int u = 0; u < urls.length; ++u) {
            this.urlEjbCLBindings.put(urls[u].getPath(), ejbClassloader);
        }
    }

    static {
        ejbjarDigester = null;
        jonasEjbjarDigester = null;
        ejbjarRuleSet = new EjbJarRuleSet();
        jonasEjbjarRuleSet = new JonasEjbJarRuleSet();
        logger = Log.getLogger("org.ow2.jonas.deployment.ejb");
        staticCache = new Hashtable();
        xmlContent = "";
        jonasXmlContent = "";
    }
}

