/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.Qname;
import org.ow2.jonas.deployment.ws.xml.JavaWsdlMapping;
import org.ow2.jonas.deployment.ws.xml.JavaXmlTypeMapping;
import org.ow2.jonas.deployment.ws.xml.PackageMapping;

public class MappingFile {
    private Map namespacePackageMapping;
    private Map xmlType2javaClassname;
    private JavaWsdlMapping javaWSDLMapping;

    public MappingFile(JavaWsdlMapping jwMapping) {
        this.javaWSDLMapping = jwMapping;
        this.namespacePackageMapping = new Hashtable();
        this.xmlType2javaClassname = new Hashtable();
        this.fillPackageMapping(jwMapping);
        this.fillXmlTypeMapping(jwMapping);
    }

    private void fillPackageMapping(JavaWsdlMapping mapping) {
        JLinkedList pml = mapping.getPackageMappingList();
        Iterator i = pml.iterator();
        while (i.hasNext()) {
            PackageMapping pm = (PackageMapping)i.next();
            String pt = pm.getPackageType();
            String nuri = pm.getNamespaceURI();
            this.namespacePackageMapping.put(nuri, pt);
        }
    }

    private void fillXmlTypeMapping(JavaWsdlMapping mapping) {
        JLinkedList jxml = mapping.getJavaXmlTypeMappingList();
        Iterator i = jxml.iterator();
        while (i.hasNext()) {
            JavaXmlTypeMapping jxtm = (JavaXmlTypeMapping)i.next();
            QName xmlName = null;
            String javaName = jxtm.getJavaType();
            Qname rootType = jxtm.getRootTypeQname();
            xmlName = rootType != null ? rootType.getQName() : jxtm.getAnonymousTypeQname().getQName();
            this.xmlType2javaClassname.put(xmlName, javaName);
        }
    }

    public JavaWsdlMapping getXmlJavaWsdlMapping() {
        return this.javaWSDLMapping;
    }

    public Map getMappings() {
        return this.namespacePackageMapping;
    }

    public String getMapping(String namespaceURI) {
        return (String)this.namespacePackageMapping.get(namespaceURI);
    }

    public String getClassname(QName xmlType) {
        return (String)this.xmlType2javaClassname.get(xmlType);
    }

    public Iterator getXmlTypeMappings() {
        return this.xmlType2javaClassname.keySet().iterator();
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("\n" + this.getClass().getName());
        ret.append("\ngetMappings()=" + this.namespacePackageMapping);
        ret.append("\ngetXmlTypeMappings()=" + this.xmlType2javaClassname);
        return ret.toString();
    }

    public int hashCode() {
        return ((Object)this.namespacePackageMapping).hashCode() + ((Object)this.xmlType2javaClassname).hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MappingFile)) {
            return false;
        }
        MappingFile ref = (MappingFile)other;
        return ((Object)this.namespacePackageMapping).equals(ref.getMappings());
    }
}

