/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.common.AbsDeploymentDesc;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.deployment.ws.WSDLFile;
import org.ow2.jonas.deployment.ws.WSDeploymentDescException;
import org.ow2.jonas.deployment.ws.xml.JonasWebserviceDescription;
import org.ow2.jonas.deployment.ws.xml.JonasWebservices;
import org.ow2.jonas.deployment.ws.xml.WebserviceDescription;
import org.ow2.jonas.deployment.ws.xml.Webservices;
import org.ow2.jonas.lib.util.I18n;

public class WSDeploymentDesc
extends AbsDeploymentDesc {
    private Vector services = new Vector();
    private String displayName;
    private String warFile = null;
    private Logger logger;
    private static I18n i18n = I18n.getInstance(WSDeploymentDesc.class);
    private String contextRoot = null;

    public WSDeploymentDesc(ClassLoader jarCL, Logger log, Webservices ws, JonasWebservices jws) throws WSDeploymentDescException {
        int i;
        int j;
        List pcl;
        this.logger = log;
        this.displayName = ws.getDisplayName();
        if (jws != null) {
            String ctx;
            if (jws.getWar() != null) {
                this.warFile = jws.getWar();
            }
            if ((ctx = jws.getContextRoot()) != null && !"".equals(ctx)) {
                this.contextRoot = ctx;
            }
        }
        JLinkedList wdl = ws.getWebserviceDescriptionList();
        Map links = this.associateWDAndJWD(ws, jws);
        for (int i2 = 0; i2 < wdl.size(); ++i2) {
            WebserviceDescription wd = (WebserviceDescription)wdl.get(i2);
            JonasWebserviceDescription jwd = (JonasWebserviceDescription)links.get(wd.getWebserviceDescriptionName());
            this.services.add(new ServiceDesc(jarCL, wd, jwd));
        }
        Vector serviceNames = new Vector();
        for (int i3 = 0; i3 < this.services.size(); ++i3) {
            String sn = ((ServiceDesc)this.services.get(i3)).getName();
            if (serviceNames.contains(sn)) {
                String err = WSDeploymentDesc.getI18n().getMessage("WSDeploymentDesc.serviceNameNotUnique", sn);
                this.logger.log(BasicLevel.ERROR, (Object)err);
                throw new WSDeploymentDescException(err);
            }
            serviceNames.add(sn);
        }
        Vector pcNames = new Vector();
        for (int i4 = 0; i4 < this.services.size(); ++i4) {
            ServiceDesc s = (ServiceDesc)this.services.get(i4);
            pcl = s.getPortComponents();
            for (j = 0; j < pcl.size(); ++j) {
                PortComponentDesc pcd = (PortComponentDesc)pcl.get(j);
                String pcn = pcd.getName();
                if (pcNames.contains(pcn)) {
                    String err = WSDeploymentDesc.getI18n().getMessage("WSDeploymentDesc.portCompNameNotUnique", pcn);
                    this.logger.log(BasicLevel.ERROR, (Object)err);
                    throw new WSDeploymentDescException(err);
                }
                pcNames.add(pcn);
            }
        }
        Vector pcQNames = new Vector();
        for (i = 0; i < this.services.size(); ++i) {
            pcl = ((ServiceDesc)this.services.get(i)).getPortComponents();
            for (j = 0; j < pcl.size(); ++j) {
                PortComponentDesc pc = (PortComponentDesc)pcl.get(j);
                pcQNames.add(pc.getQName());
            }
        }
        for (i = 0; i < this.services.size(); ++i) {
            WSDLFile wsdlf = ((ServiceDesc)this.services.get(i)).getWSDL();
            if (wsdlf.hasPortsIncludedIn(pcQNames)) continue;
            String err = WSDeploymentDesc.getI18n().getMessage("WSDeploymentDesc.wsdlDeclareUnknownPort", wsdlf.getName());
            this.logger.log(BasicLevel.ERROR, (Object)err);
            throw new WSDeploymentDescException(err);
        }
    }

    private Map associateWDAndJWD(Webservices ws, JonasWebservices jws) {
        HashMap res = new HashMap();
        Iterator i = ws.getWebserviceDescriptionList().iterator();
        while (i.hasNext()) {
            WebserviceDescription wsd = (WebserviceDescription)i.next();
            res.put(wsd.getWebserviceDescriptionName(), null);
        }
        if (jws != null) {
            Set keys = res.keySet();
            Iterator i2 = jws.getJonasWebserviceDescriptionList().iterator();
            while (i2.hasNext()) {
                JonasWebserviceDescription jwsd = (JonasWebserviceDescription)i2.next();
                String wsdName = jwsd.getWebserviceDescriptionName();
                if (keys.contains(wsdName)) {
                    res.put(wsdName, jwsd);
                    continue;
                }
                String err = "jonas-webservice-description '" + wsdName + "' is not linked to any webservice-description. It will be ignored.";
                this.logger.log(BasicLevel.WARN, (Object)err);
            }
        }
        return res;
    }

    public List getServiceDescs() {
        return this.services;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nWSDeploymentDesc :");
        sb.append("\ngetDisplayName()=" + this.getDisplayName());
        Iterator i = this.getServiceDescs().iterator();
        while (i.hasNext()) {
            sb.append("\ngetServiceDesc()=" + ((ServiceDesc)i.next()).toString());
        }
        sb.append("\ngetWarFile()=" + this.getWarFile());
        return sb.toString();
    }

    public String getWarFile() {
        return this.warFile;
    }

    protected static I18n getI18n() {
        return i18n;
    }
}

