/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader.locator;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.ow2.jonas.lib.loader.locator.Locator;

public class JarFileLocator
extends Locator {
    private JarFile file = null;

    public JarFileLocator(URL jar) throws IOException {
        String filename = jar.getFile();
        this.file = new JarFile(filename);
    }

    public boolean hasFile(String path) {
        ZipEntry entry = this.file.getEntry(path);
        return entry != null;
    }

    public boolean hasDirectory(String path) {
        boolean found = false;
        Enumeration e = this.file.entries();
        while (e.hasMoreElements() && !found) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            if (!entry.getName().startsWith(path)) continue;
            return true;
        }
        return false;
    }

    public List listContent(String path) {
        Vector libs = new Vector();
        Enumeration e = this.file.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            if (!entry.getName().startsWith(path)) continue;
            libs.add(entry.getName());
        }
        return libs;
    }
}

