/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.archive.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.api.IArchiveFactory;
import org.ow2.util.archive.api.IArchiveManager;
import org.ow2.util.archive.impl.DefaultArchiveFactory;
import org.ow2.util.archive.impl.URLArchiveFactory;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArchiveManager
implements IArchiveManager {
    private static Log logger = LogFactory.getLog(ArchiveManager.class);
    private static ArchiveManager archiveManager;
    private Map<Class<?>, IArchiveFactory<?>> factories = new HashMap();

    private ArchiveManager() {
        this.addFactory(new DefaultArchiveFactory());
        this.addFactory(new URLArchiveFactory());
    }

    public static ArchiveManager getInstance() {
        if (archiveManager == null) {
            archiveManager = new ArchiveManager();
        }
        return archiveManager;
    }

    @Override
    public void addFactory(IArchiveFactory<?> factory) {
        Class factoryClass = factory.getClass();
        Class<?> argumentClass = factory.getSupportedClass();
        logger.debug("Adding factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'.", new Object[0]);
        this.factories.put(argumentClass, factory);
    }

    @Override
    public void removeFactory(IArchiveFactory<?> factory) {
        Class factoryClass = factory.getClass();
        Class<?> argumentClass = factory.getSupportedClass();
        if (this.factories.containsKey(argumentClass)) {
            logger.debug("Removing factory '" + factoryClass.getName() + "' for class '" + argumentClass + "'.", new Object[0]);
            this.factories.remove(argumentClass);
        } else {
            logger.debug("Factory '" + factoryClass.getName() + "' was not registered in the ArchiveManager.", new Object[0]);
        }
    }

    @Override
    public IArchive getArchive(Object o) {
        Class objectClass = o.getClass();
        IArchiveFactory factory = (IArchiveFactory)this.factories.get((Object)objectClass);
        if (factory == null) {
            Iterator i$ = this.factories.keySet().iterator();
            while (i$.hasNext()) {
                Class cls = (Class)i$.next();
                if (!cls.isAssignableFrom(objectClass) || factory != null) continue;
                factory = (IArchiveFactory)this.factories.get((Object)cls);
            }
            if (factory == null) {
                throw new IllegalArgumentException("No factory found for the type '" + objectClass + "'.");
            }
        }
        return factory.create(o);
    }
}

