/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.helper.DeployableEntry;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModifyDeployableHelper {
    public static final String DEFAULT_FOLDER = "EE-ModifierDeployer";

    private ModifyDeployableHelper() {
    }

    public static <T extends IDeployable<T>> void addInDeployable(T deployable, List<DeployableEntry> entries) throws DeployerException {
        File rootFolder = new File(System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FOLDER + "-" + System.getProperty("user.name", "default"));
        ModifyDeployableHelper.addInDeployable(deployable, entries, rootFolder);
    }

    public static <T extends IDeployable<T>> void addInDeployable(T deployable, List<DeployableEntry> entries, File workingFolder) throws DeployerException {
        workingFolder.mkdirs();
        T workDeployable = deployable;
        T unpackedDeployable = deployable.getUnpackedDeployable();
        if (unpackedDeployable == null) {
            URL tmpURL = null;
            try {
                tmpURL = deployable.getArchive().getURL();
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get URL on deployable '" + deployable + "'");
            }
            String archiveName = URLUtils.shorterName(tmpURL);
            unpackedDeployable = UnpackDeployableHelper.unpack(workDeployable, workingFolder, archiveName);
            deployable.setUnpackedDeployable(unpackedDeployable);
            unpackedDeployable.setOriginalDeployable(deployable);
        }
        URL urlDeployable = null;
        try {
            urlDeployable = unpackedDeployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get URL for the deployable '" + unpackedDeployable + "'.", e);
        }
        if (!"file".equals(urlDeployable.getProtocol())) {
            throw new DeployerException("Protocol for unpacked deployable '" + unpackedDeployable + "' is not a file");
        }
        File unpackedDir = URLUtils.urlToFile(urlDeployable);
        if (!unpackedDir.isDirectory()) {
            throw new DeployerException("The file '" + unpackedDir + "' is not a directory");
        }
        if (entries == null) {
            return;
        }
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            FileInputStream is;
            DeployableEntry depEntry = (DeployableEntry)i$.next();
            String entryName = depEntry.getName();
            File f = depEntry.getFile();
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {
                throw new DeployerException("Cannot get stream on file '" + f + "'", e);
            }
            File writingFile = new File(unpackedDir, entryName.replace((CharSequence)"/", (CharSequence)File.separator));
            writingFile.getParentFile().mkdirs();
            try {
                FileUtils.dump(is, writingFile);
            }
            catch (FileUtilsException e) {
                e.printStackTrace();
                throw new DeployerException("Cannot dump stream of file '" + f + "'", e);
            }
            finally {
                if (is == null) continue;
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    throw new DeployerException("Cannot close stream of file '" + f + "'", e);
                }
            }
        }
    }
}

