/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.osgi;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDeployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(OSGiDeployer.class);
    private BundleContext bundleContext = null;
    private Map<String, Bundle> installedBundles = null;
    private StartLevel startLevel = null;

    public OSGiDeployer(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.installedBundles = new HashMap();
        ServiceReference serviceReference = bundleContext.getServiceReference(StartLevel.class.getName());
        this.startLevel = (StartLevel)bundleContext.getService(serviceReference);
    }

    @Override
    public void doUndeploy(IDeployable<?> osgiDeployable) throws DeployerException {
        this.logger.debug("Undeploying {0}", osgiDeployable);
        Bundle osgiBundle = null;
        if (!this.isDeployed(osgiDeployable)) {
            throw new DeployerException("Cannot undeploy the bundle '" + osgiDeployable + "' as it was not deployed.");
        }
        osgiBundle = (Bundle)this.installedBundles.get((Object)this.getURL(osgiDeployable).toExternalForm());
        if (osgiBundle == null) {
            throw new DeployerException("No bundle found for the '" + osgiDeployable + "'.");
        }
        try {
            osgiBundle.stop();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot stop the bundle '" + osgiDeployable + "'.", e);
        }
        try {
            osgiBundle.uninstall();
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot uninstall the bundle '" + osgiDeployable + "'.", e);
        }
        this.installedBundles.remove((Object)this.getURL(osgiDeployable).toExternalForm());
    }

    @Override
    public void doDeploy(IDeployable<?> osgiDeployable) throws DeployerException {
        this.logger.debug("Deploying {0}", osgiDeployable);
        Bundle osgiBundle = null;
        this.startLevel.setInitialBundleStartLevel(((OSGiDeployable)osgiDeployable).getStartLevel());
        try {
            String url = this.getURL(osgiDeployable).toExternalForm();
            if (((OSGiDeployable)osgiDeployable).isReference().booleanValue()) {
                url = "reference:".concat(url);
            }
            osgiBundle = this.bundleContext.installBundle(url);
        }
        catch (BundleException e) {
            throw new DeployerException("Cannot install the bundle '" + osgiDeployable + "'.", e);
        }
        if (((OSGiDeployable)osgiDeployable).isStart().booleanValue()) {
            try {
                osgiBundle.start();
            }
            catch (BundleException e) {
                this.logger.error("Cannot start the bundle ''{0}''.", osgiDeployable, e);
            }
        }
        this.installedBundles.put((Object)this.getURL(osgiDeployable).toExternalForm(), (Object)osgiBundle);
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof OSGiDeployable;
    }

    @Override
    protected void check(IDeployable<?> deployable) throws DeployerException {
        if (this.bundleContext == null) {
            throw new DeployerException("The deployment of the deployable'" + deployable + "' is not available as there is no bundle context set on this deployer.");
        }
        super.check(deployable);
    }
}

