/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.common.impl.helper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.ow2.util.asm.Type;
import org.ow2.util.ee.metadata.common.api.ICommonMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodHelper {
    private MethodHelper() {
    }

    public static String getSignature(ICommonMethodMetadata<?, ?, ?> methodMetadata) {
        return methodMetadata.getJMethod().getName() + methodMetadata.getJMethod().getDescriptor().hashCode();
    }

    public static Method getMethod(JMethod jMethod, Class<?> clazz) {
        String methodName = jMethod.getName();
        Type[] argumentTypes = Type.getArgumentTypes(jMethod.getDescriptor());
        Class[] parameterTypes = null;
        if (argumentTypes != null) {
            ArrayList parameters = new ArrayList();
            for (Type type : argumentTypes) {
                try {
                    String parameterClassName = type.getClassName().replace((CharSequence)"/", (CharSequence)".");
                    Class parameterClass = null;
                    parameterClass = "int".equals(parameterClassName) ? Integer.TYPE : ("byte".equals(parameterClassName) ? Byte.TYPE : ("char".equals(parameterClassName) ? Character.TYPE : ("long".equals(parameterClassName) ? Long.TYPE : ("short".equals(parameterClassName) ? Short.TYPE : ("float".equals(parameterClassName) ? Float.TYPE : ("double".equals(parameterClassName) ? Double.TYPE : ("boolean".equals(parameterClassName) ? Boolean.TYPE : (9 == type.getSort() ? Class.forName(type.getDescriptor().replace('/', '.'), true, clazz.getClassLoader()) : clazz.getClassLoader().loadClass(parameterClassName)))))))));
                    parameters.add(parameterClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load the class '" + type.getClassName() + "'.", (Throwable)e);
                }
            }
            parameterTypes = (Class[])parameters.toArray(new Class[parameters.size()]);
        }
        try {
            return clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to get the method '" + methodName + "'.", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to get the method '" + methodName + "'.", (Throwable)e);
        }
    }

    public static Method getMethod(String classname, JMethod jMethod, ClassLoader classLoader) {
        Class clazz;
        try {
            clazz = classLoader.loadClass(classname.replace((CharSequence)"/", (CharSequence)"."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the class '" + classname + "'.", (Throwable)e);
        }
        return MethodHelper.getMethod(jMethod, clazz);
    }
}

