/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.war.impl.xml.parsing;

import java.net.URL;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.AbsWebLoader;
import org.ow2.util.ee.metadata.war.impl.xml.parsing.WAREntityResolver;
import org.ow2.util.ee.metadata.war.impl.xml.struct.WAR;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class WARDeploymentDescLoader
extends AbsWebLoader {
    private static Log logger = LogFactory.getLog(WARDeploymentDescLoader.class);

    protected WARDeploymentDescLoader(URL url) {
        super(url);
    }

    public static WAR loadDeploymentDescriptor(URL url, boolean validation) throws ParsingException {
        logger.debug("Analyzing url {0}", url);
        WARDeploymentDescLoader warDeploymentDescLoader = new WARDeploymentDescLoader(url);
        warDeploymentDescLoader.setValidating(validation);
        warDeploymentDescLoader.parse();
        return warDeploymentDescLoader.getWAR();
    }

    public void parse() throws ParsingException {
        Document document = null;
        try {
            document = DocumentParser.getDocument(this.getURL(), WARDeploymentDescLoader.isValidating(), (EntityResolver)new WAREntityResolver());
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", e);
        }
        Element webAppRootElement = document.getDocumentElement();
        if (webAppRootElement.getNamespaceURI() != null) {
            this.defineXMLNS(webAppRootElement);
        }
        this.analyzeEnvironment(webAppRootElement, this.getWAR());
        this.analyzeServlets(webAppRootElement);
        this.analyzeListeners(webAppRootElement);
        this.analyzeFilters(webAppRootElement);
        String metadataComplete = webAppRootElement.getAttribute("metadata-complete");
        if (metadataComplete.equals("true")) {
            this.getWAR().setMetadataComplete(true);
        }
        if (WARDeploymentDescLoader.isValidating()) {
            if (!this.analyzeJspConfig(webAppRootElement)) {
                throw new ParsingException(" web.xml must not contain multiple elements of jsp-config");
            }
            if (!this.analyzeSessionConfig(webAppRootElement)) {
                throw new ParsingException(" web.xml must not contain multiple elements of session-config");
            }
            if (!this.analyzeLoginConfig(webAppRootElement)) {
                throw new ParsingException(" web.xml must not contain multiple elements of login-config");
            }
            if (!this.analyzeUrlPattern(webAppRootElement)) {
                throw new ParsingException(" a '\\n' character inside the url pattern is forbidden");
            }
        }
    }
}

