/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ws.impl.xml.merge;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.ow2.util.ee.metadata.ws.api.IWebservicesCommonClassMetadata;
import org.ow2.util.ee.metadata.ws.api.IWebservicesDeployableMetadata;
import org.ow2.util.ee.metadata.ws.api.struct.IWebServiceMarker;
import org.ow2.util.ee.metadata.ws.api.xml.merge.IClassMetadataFinder;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IPortComponent;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IServiceImplBean;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebserviceDescription;
import org.ow2.util.ee.metadata.ws.api.xml.struct.IWebservices;

public class WebservicesMetadataMerger {
    private IWebservicesDeployableMetadata metadata;
    private IClassMetadataFinder finder;

    public WebservicesMetadataMerger(IWebservicesDeployableMetadata wsMetadata, IClassMetadataFinder finder) {
        this.metadata = wsMetadata;
        this.finder = finder;
    }

    public static void merge(IWebservicesDeployableMetadata wsMetadata, IClassMetadataFinder finder) {
        new WebservicesMetadataMerger(wsMetadata, finder).resolve();
    }

    private void resolve() {
        IWebservices webservices = this.metadata.getWebservices12();
        if (webservices == null) {
            return;
        }
        Iterator i$ = webservices.getWebserviceDescriptions().iterator();
        while (i$.hasNext()) {
            IWebserviceDescription wsd = (IWebserviceDescription)i$.next();
            String wsdlLocation = wsd.getWsdlFile();
            Iterator i$2 = wsd.getPortComponents().iterator();
            while (i$2.hasNext()) {
                IPortComponent pc = (IPortComponent)i$2.next();
                String name = pc.getName();
                IServiceImplBean sib = pc.getServiceImplBean();
                String link = null;
                link = sib.getEjbLink() != null ? sib.getEjbLink() : sib.getServletLink();
                IWebservicesCommonClassMetadata classMetadata = this.finder.findClassMetadata(link);
                if (classMetadata == null) {
                    throw new IllegalStateException("Invalid link for port-component '" + name + "', component '" + link + "' not found");
                }
                IWebServiceMarker webService = classMetadata.getWebServiceMarker();
                if (webService == null) continue;
                this.mergeWebService(classMetadata, wsd, pc);
            }
        }
    }

    private void mergeWebService(IWebservicesCommonClassMetadata classMetadata, IWebserviceDescription webserviceDescription, IPortComponent portComponent) {
        String endpointInterface;
        String binding;
        QName wsdlPort;
        QName wsdlService;
        IWebServiceMarker marker = classMetadata.getWebServiceMarker();
        String wsdlFile = webserviceDescription.getWsdlFile();
        if (!WebservicesMetadataMerger.isNullOrEmpty(wsdlFile)) {
            marker.setWsdlLocation(wsdlFile);
        }
        if ((wsdlService = portComponent.getWsdlService()) != null) {
            marker.setServiceName(wsdlService);
        }
        if ((wsdlPort = portComponent.getWsdlPort()) != null) {
            marker.setPortName(wsdlPort);
        }
        if (!WebservicesMetadataMerger.isNullOrEmpty(binding = portComponent.getProtocolBinding())) {
            marker.setProtocolBinding(binding);
        }
        boolean enabled = portComponent.isMTOMEnabled();
        marker.setEnableMtom(enabled);
        if (!marker.isWebServiceProvider() && !WebservicesMetadataMerger.isNullOrEmpty(endpointInterface = portComponent.getServiceEndpointInterface())) {
            marker.setEndpointInterface(endpointInterface);
        }
        marker.setHandlerChains(portComponent.getHandlerChains());
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || "".equals(value);
    }
}

