/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.event.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.event.api.IEventService;

public class EventService
implements IEventService {
    private boolean available = false;
    private Map<String, IEventDispatcher> ids2dispatchers = new HashMap();
    private Map<IEventListener, String> listeners2regexps = new HashMap();
    private Map<IEventDispatcher, Map<String, Set<IEventListener>>> dispatchers2ids2listeners = new HashMap();
    private Map<IEventDispatcher, Map<IEventListener, Set<String>>> dispatchers2listeners2ids = new HashMap();

    public synchronized void start() {
        if (!this.available) {
            this.available = true;
            Iterator i$ = this.dispatchers2listeners2ids.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                IEventDispatcher dispatcher = (IEventDispatcher)entry.getKey();
                Set listeners = ((Map)entry.getValue()).keySet();
                Iterator i$2 = listeners.iterator();
                while (i$2.hasNext()) {
                    IEventListener listener = (IEventListener)i$2.next();
                    dispatcher.addListener(listener);
                }
            }
        }
    }

    public synchronized void stop() {
        if (this.available) {
            this.available = false;
            Iterator i$ = this.dispatchers2listeners2ids.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                IEventDispatcher dispatcher = (IEventDispatcher)entry.getKey();
                Set listeners = ((Map)entry.getValue()).keySet();
                Iterator i$2 = listeners.iterator();
                while (i$2.hasNext()) {
                    IEventListener listener = (IEventListener)i$2.next();
                    dispatcher.removeListener(listener);
                }
            }
        }
    }

    public synchronized IEventDispatcher getDispatcher(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        return (IEventDispatcher)this.ids2dispatchers.get((Object)id);
    }

    public synchronized void registerDispatcher(String id, IEventDispatcher dispatcher) {
        Map ids2listeners;
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        this.unregisterDispatcher(id);
        this.ids2dispatchers.put((Object)id, (Object)dispatcher);
        Map listeners2ids = (Map)this.dispatchers2listeners2ids.get((Object)dispatcher);
        if (listeners2ids == null) {
            listeners2ids = new HashMap();
            this.dispatchers2listeners2ids.put((Object)dispatcher, (Object)listeners2ids);
        }
        if ((ids2listeners = (Map)this.dispatchers2ids2listeners.get((Object)dispatcher)) == null) {
            ids2listeners = new HashMap();
            this.dispatchers2ids2listeners.put((Object)dispatcher, (Object)ids2listeners);
        }
        HashSet listeners = new HashSet();
        ids2listeners.put(id, listeners);
        Iterator i$ = this.listeners2regexps.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            IEventListener listener = (IEventListener)entry.getKey();
            String regexp = (String)entry.getValue();
            if (!id.matches(regexp)) continue;
            Set ids = (Set)listeners2ids.get(listener);
            if (ids == null) {
                ids = new HashSet();
                listeners2ids.put(listener, ids);
                dispatcher.addListener(listener);
            }
            ids.add(id);
            listeners.add(listener);
        }
    }

    public synchronized void unregisterDispatcher(String id) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        if (id == null) {
            throw new IllegalArgumentException();
        }
        IEventDispatcher dispatcher = (IEventDispatcher)this.ids2dispatchers.remove((Object)id);
        if (dispatcher != null) {
            Map ids2listeners = (Map)this.dispatchers2ids2listeners.get((Object)dispatcher);
            Map listeners2ids = (Map)this.dispatchers2listeners2ids.get((Object)dispatcher);
            Set listeners = (Set)ids2listeners.remove(id);
            if (ids2listeners.size() == 0) {
                this.dispatchers2ids2listeners.remove((Object)dispatcher);
                this.dispatchers2listeners2ids.remove((Object)dispatcher);
            }
            Iterator i$ = listeners.iterator();
            while (i$.hasNext()) {
                IEventListener listener = (IEventListener)i$.next();
                Set ids = (Set)listeners2ids.get(listener);
                ids.remove(id);
                if (ids.size() != 0) continue;
                listeners2ids.remove(listener);
                dispatcher.removeListener(listener);
            }
        }
    }

    public synchronized void registerListener(IEventListener listener, String regexp) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        this.unregisterListener(listener);
        this.listeners2regexps.put((Object)listener, (Object)regexp);
        Iterator i$ = this.ids2dispatchers.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry entry = (Map.Entry)i$.next();
            String id = (String)entry.getKey();
            IEventDispatcher dispatcher = (IEventDispatcher)entry.getValue();
            if (!id.matches(regexp)) continue;
            Map ids2listeners = (Map)this.dispatchers2ids2listeners.get((Object)dispatcher);
            Map listeners2ids = (Map)this.dispatchers2listeners2ids.get((Object)dispatcher);
            Set listeners = (Set)ids2listeners.get(id);
            Set ids = (Set)listeners2ids.get(listener);
            if (ids == null) {
                ids = new HashSet();
                listeners2ids.put(listener, ids);
                dispatcher.addListener(listener);
            }
            ids.add(id);
            listeners.add(listener);
        }
    }

    public synchronized void unregisterListener(IEventListener listener) {
        if (!this.available) {
            throw new IllegalStateException();
        }
        String regexp = (String)this.listeners2regexps.remove((Object)listener);
        if (regexp != null) {
            Iterator i$ = this.ids2dispatchers.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry entry = (Map.Entry)i$.next();
                String id = (String)entry.getKey();
                IEventDispatcher dispatcher = (IEventDispatcher)entry.getValue();
                if (!id.matches(regexp)) continue;
                Map ids2listeners = (Map)this.dispatchers2ids2listeners.get((Object)dispatcher);
                Map listeners2ids = (Map)this.dispatchers2listeners2ids.get((Object)dispatcher);
                Set listeners = (Set)ids2listeners.get(id);
                Set ids = (Set)listeners2ids.get(listener);
                ids.remove(id);
                listeners.remove(listener);
                if (ids.size() != 0) continue;
                listeners2ids.remove(listener);
                dispatcher.removeListener(listener);
            }
        }
    }
}

