/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.api.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ow2.util.scan.api.metadata.CommonMetadata;
import org.ow2.util.scan.api.metadata.IClassMetadata;
import org.ow2.util.scan.api.metadata.IFieldMetadata;
import org.ow2.util.scan.api.metadata.IMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassMetadata<C extends IClassMetadata<C, M, F>, M extends IMethodMetadata<C, M, F>, F extends IFieldMetadata<C, M, F>>
extends CommonMetadata
implements IClassMetadata<C, M, F> {
    private static final long serialVersionUID = 1392857823357889714L;
    private JClass jClass;
    private Map<JMethod, M> methodsAnnotationMetadata = new HashMap();
    private Map<JField, F> fieldsAnnotationMetadata = new HashMap();

    @Override
    public final void addStandardMethodMetadata(M methodAnnotationMetadata) {
        JMethod key = methodAnnotationMetadata.getJMethod();
        this.methodsAnnotationMetadata.put((Object)key, methodAnnotationMetadata);
    }

    @Override
    @Deprecated
    public final M getStandardMethodMetadata(JMethod jMethod) {
        return this.getMethodMetadata(jMethod);
    }

    public final M getMethodMetadata(JMethod jMethod) {
        return (M)((IMethodMetadata)this.methodsAnnotationMetadata.get((Object)jMethod));
    }

    @Override
    public final List<M> searchStandardMethodMetadata(String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException("Cannot search null methods");
        }
        ArrayList list = new ArrayList();
        Iterator i$ = this.methodsAnnotationMetadata.values().iterator();
        while (i$.hasNext()) {
            IMethodMetadata method = (IMethodMetadata)i$.next();
            if (!methodName.equals(method.getJMethod().getName())) continue;
            list.add(method);
        }
        return list;
    }

    @Override
    public final List<F> searchStandardFieldMetadata(String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException("Cannot search null fields");
        }
        ArrayList list = new ArrayList();
        Iterator i$ = this.fieldsAnnotationMetadata.values().iterator();
        while (i$.hasNext()) {
            IFieldMetadata field = (IFieldMetadata)i$.next();
            if (!fieldName.equals(field.getJField().getName())) continue;
            list.add(field);
        }
        return list;
    }

    @Override
    @Deprecated
    public final Collection<M> getStandardMethodMetadataCollection() {
        return this.getMethodMetadataCollection();
    }

    public final Collection<M> getMethodMetadataCollection() {
        return this.methodsAnnotationMetadata.values();
    }

    @Override
    public void addStandardFieldMetadata(F fieldAnnotationMetadata) {
        JField key = fieldAnnotationMetadata.getJField();
        if (this.fieldsAnnotationMetadata.containsKey((Object)key)) {
            throw new IllegalStateException();
        }
        this.fieldsAnnotationMetadata.put((Object)key, fieldAnnotationMetadata);
    }

    @Override
    public F getStandardFieldMetadata(JField jField) {
        return (F)((IFieldMetadata)this.fieldsAnnotationMetadata.get((Object)jField));
    }

    @Override
    public final Collection<F> getStandardFieldMetadataCollection() {
        return this.fieldsAnnotationMetadata.values();
    }

    @Override
    public final JClass getJClass() {
        return this.jClass;
    }

    @Override
    public final void setJClass(JClass jClass) {
        this.jClass = jClass;
    }
}

