/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.scan.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.ow2.util.asm.ClassVisitor;
import org.ow2.util.asm.FieldVisitor;
import org.ow2.util.asm.MethodVisitor;
import org.ow2.util.scan.api.configurator.IArchiveConfigurator;
import org.ow2.util.scan.api.configurator.IClassConfigurator;
import org.ow2.util.scan.api.metadata.structures.JClass;
import org.ow2.util.scan.api.metadata.structures.JField;
import org.ow2.util.scan.api.metadata.structures.JMethod;
import org.ow2.util.scan.impl.ScanCommonVisitor;
import org.ow2.util.scan.impl.ScanFieldVisitor;
import org.ow2.util.scan.impl.ScanMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScanClassVisitor
extends ScanCommonVisitor<IClassConfigurator>
implements ClassVisitor {
    private List<? extends IArchiveConfigurator> archiveConfigurators;
    private Set<String> referencedClasses;

    public ScanClassVisitor(List<? extends IArchiveConfigurator> archiveConfigurators, Set<String> referencedClasses) {
        this.archiveConfigurators = archiveConfigurators;
        this.referencedClasses = referencedClasses;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList classConfigurators = new ArrayList();
        JClass jClass = new JClass(version, access, name, signature, superName, interfaces);
        Iterator i$ = this.archiveConfigurators.iterator();
        while (i$.hasNext()) {
            IArchiveConfigurator archiveConfigurator = (IArchiveConfigurator)i$.next();
            classConfigurators.add(archiveConfigurator.createClassConfigurator(jClass));
        }
        this.setConfigurators(classConfigurators);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        JMethod jMethod = new JMethod(access, name, desc, signature, exceptions);
        ArrayList methodConfigurators = new ArrayList();
        Iterator i$ = this.getConfigurators().iterator();
        while (i$.hasNext()) {
            IClassConfigurator classConfigurator = (IClassConfigurator)i$.next();
            methodConfigurators.add(classConfigurator.createMethodConfigurator(jMethod));
        }
        return new ScanMethodVisitor(methodConfigurators, this.referencedClasses);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        JField jField = new JField(access, name, desc, signature, value);
        ArrayList fieldConfigurators = new ArrayList();
        Iterator i$ = this.getConfigurators().iterator();
        while (i$.hasNext()) {
            IClassConfigurator classConfigurator = (IClassConfigurator)i$.next();
            fieldConfigurators.add(classConfigurator.createFieldConfigurator(jField));
        }
        return new ScanFieldVisitor(fieldConfigurators, this.referencedClasses);
    }

    @Override
    public void visitEnd() {
        Iterator i$ = this.getConfigurators().iterator();
        while (i$.hasNext()) {
            IClassConfigurator classConfigurator = (IClassConfigurator)i$.next();
            classConfigurator.configurationComplete(this.referencedClasses);
        }
    }
}

