/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.eventswitch.beans.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.ow2.jasmine.event.beans.JasmineEventEB;
import org.ow2.jasmine.monitoring.eventswitch.beans.JasmineEventSLBRemote;
import org.ow2.jasmine.monitoring.eventswitch.beans.impl.JasmineEventEBImpl;

@Stateless
@Remote(value={JasmineEventSLBRemote.class})
public class JasmineEventSLBImpl
implements JasmineEventSLBRemote {
    @PersistenceContext
    private EntityManager entityManager = null;

    public void saveEvent(JasmineEventEB e) {
        JasmineEventEBImpl bean = new JasmineEventEBImpl();
        bean.setDomain(e.getDomain());
        bean.setServer(e.getServer());
        bean.setSource(e.getSource());
        bean.setProbe(e.getProbe());
        bean.setValue(e.getValue().toString());
        bean.setTimestamp(e.getTimestamp());
        bean.setSname(e.getSname());
        this.entityManager.persist((Object)bean);
    }

    public JasmineEventEB[] getEvents(String domain, String server, String source, String probe, String value, Date startTimestamp, Date endTimestamp, String orderBy, int limit) {
        int i;
        HashMap<String, Object> queryElements = new HashMap<String, Object>();
        queryElements.put("domain", domain);
        queryElements.put("source", source);
        queryElements.put("value", value);
        queryElements.put("startTimestamp", startTimestamp);
        queryElements.put("endTimestamp", endTimestamp);
        String[] probes = probe.split("separator");
        String[] servers = server.split("separator");
        for (int j = 0; j < probes.length; ++j) {
            queryElements.put("probe" + j, probes[j]);
            queryElements.put("server" + j, servers[j]);
        }
        StringBuffer stringQuery = new StringBuffer("SELECT e FROM JasmineEventEBImpl e WHERE ");
        Set keysFromHT = queryElements.keySet();
        Object[] keys = keysFromHT.toArray();
        for (i = 0; i < keys.length; ++i) {
            if (queryElements.get(keys[i].toString()) == null) continue;
            if (keys[i].toString().startsWith("domain")) {
                stringQuery.append("e.domain LIKE :");
                stringQuery.append(keys[i]);
                stringQuery.append(" AND ");
            }
            if (keys[i].toString().startsWith("source")) {
                stringQuery.append("e.source LIKE :");
                stringQuery.append(keys[i]);
                stringQuery.append(" AND ");
            }
            if (keys[i].toString().startsWith("value")) {
                stringQuery.append("e.value LIKE :");
                stringQuery.append(keys[i]);
                stringQuery.append(" AND ");
            }
            if (keys[i].toString().startsWith("startTimestamp")) {
                stringQuery.append("e.timestamp >= :");
                stringQuery.append(keys[i]);
                stringQuery.append(" AND ");
            }
            if (!keys[i].toString().startsWith("endTimestamp")) continue;
            stringQuery.append("e.timestamp <= :");
            stringQuery.append(keys[i]);
            stringQuery.append(" AND ");
        }
        for (i = 0; i < keys.length; ++i) {
            if (keys[i].toString().startsWith("probe0")) {
                stringQuery.append(" (");
            }
            if (!keys[i].toString().startsWith("probe")) continue;
            stringQuery.append("e.probe LIKE :");
            stringQuery.append(keys[i]);
            stringQuery.append(" AND ");
            for (int j = 0; j < keys.length; ++j) {
                if (!keys[j].toString().startsWith("server" + keys[i].toString().charAt(5))) continue;
                stringQuery.append("e.server LIKE :");
                stringQuery.append(keys[j]);
                if (keys[i].toString().startsWith("probe" + (probes.length - 1))) {
                    stringQuery.append(") ");
                    continue;
                }
                stringQuery.append(" OR ");
            }
        }
        if (orderBy != null) {
            stringQuery.append(" ORDER BY e.");
            stringQuery.append(orderBy);
            stringQuery.append(" ASC");
        }
        Query dbQuery = this.entityManager.createQuery(stringQuery.toString());
        dbQuery.setMaxResults(limit);
        for (String key : queryElements.keySet()) {
            if (queryElements.get(key) == null) continue;
            dbQuery.setParameter(key, queryElements.get(key));
        }
        List queryResult = dbQuery.getResultList();
        if (queryResult.size() < 1) {
            return null;
        }
        int i2 = 0;
        JasmineEventEB[] result = new JasmineEventEB[queryResult.size()];
        for (JasmineEventEBImpl bean : queryResult) {
            result[i2++] = new JasmineEventEB(bean.getDomain(), bean.getServer(), bean.getSource(), bean.getProbe(), (Serializable)((Object)bean.getValue()), bean.getTimestamp(), bean.getSname());
        }
        return result;
    }
}

