/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.OSGiDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.impl.OSGiDroolsWorkingMemoryPool;
import org.ow2.jasmine.rules.osgi.impl.PackageAdderListener;
import org.ow2.jonas.lib.bootstrap.LoaderManager;

public class Activator
implements BundleActivator {
    private static Logger logger = Logger.getLogger(Activator.class.getName());
    private ServiceRegistration serviceRegistration;
    private IDroolsWorkingMemoryPool droolsWorkingMemoryPool;
    private ServiceListener packageAdderListener;

    public void start(BundleContext context) throws Exception {
        ServiceReference[] packageAdderRefs = context.getAllServiceReferences(IPackageAdder.class.getName(), null);
        HashMap packageAdders = new HashMap();
        if (packageAdderRefs != null) {
            for (ServiceReference packageAdderRef : packageAdderRefs) {
                String workingMemoryName = ((IPackageAdder)context.getService(packageAdderRef)).getWorkingMemoryName();
                if (packageAdders.containsKey(workingMemoryName)) {
                    ((HashMap)packageAdders.get(workingMemoryName)).put(packageAdderRef, (IPackageAdder)context.getService(packageAdderRef));
                    continue;
                }
                HashMap<ServiceReference, IPackageAdder> newPackageAdders = new HashMap<ServiceReference, IPackageAdder>();
                newPackageAdders.put(packageAdderRef, (IPackageAdder)context.getService(packageAdderRef));
                packageAdders.put(workingMemoryName, newPackageAdders);
            }
        }
        boolean dumpDirExists = false;
        File dumpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + "drools_dump");
        if (Boolean.getBoolean("jonas.developer") && !(dumpDirExists = dumpDir.exists())) {
            dumpDirExists = dumpDir.mkdir();
        }
        this.droolsWorkingMemoryPool = new OSGiDroolsWorkingMemoryPool((ClassLoader)LoaderManager.getInstance().getExternalLoader());
        for (String workingMemoryName : packageAdders.keySet()) {
            logger.log(Level.INFO, "Creating and starting WorkingMemory \"" + workingMemoryName + "\"");
            OSGiDroolsWorkingMemory newDroolsWorkingMemory = new OSGiDroolsWorkingMemory((ClassLoader)LoaderManager.getInstance().getExternalLoader(), (Map)packageAdders.get(workingMemoryName));
            this.droolsWorkingMemoryPool.add(workingMemoryName, (IDroolsWorkingMemory)newDroolsWorkingMemory);
            if (Boolean.getBoolean("jonas.developer") && dumpDirExists && dumpDir.isDirectory()) {
                newDroolsWorkingMemory.setDumpDir(dumpDir);
            }
            newDroolsWorkingMemory.start();
        }
        this.packageAdderListener = new PackageAdderListener(context, (IOSGiDroolsWorkingMemoryPool)this.droolsWorkingMemoryPool);
        context.addServiceListener(this.packageAdderListener, "(objectClass=" + IPackageAdder.class.getName() + ")");
        this.serviceRegistration = context.registerService(IDroolsWorkingMemoryPool.class.getName(), (Object)this.droolsWorkingMemoryPool, null);
    }

    public void stop(BundleContext context) {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        if (this.packageAdderListener != null) {
            context.removeServiceListener(this.packageAdderListener);
        }
        this.droolsWorkingMemoryPool.stopAll();
    }
}

