/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.management.MBeanServerConnection;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import org.objectweb.jonas.common.JProp;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionFactory;
import org.ow2.jasmine.adapter.jmx.pool.api.IJMXConnectionServer;
import org.ow2.jasmine.adapter.jmx.pool.api.JMXConnectionParam;
import org.ow2.jasmine.monitoring.mbeancmd.CommandDispatcher;
import org.ow2.jasmine.monitoring.mbeancmd.JmxCnxWrapper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JmxAP {
    private static Context ctx = null;
    private CommandDispatcher cmdDispatcher = null;
    private MBeanServerConnection jmxConnection = null;
    private IJMXConnectionServer jmxConnectionEmbedded = null;
    private String jmxUrl = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    private static Map<String, String> jmxTargets = new TreeMap<String, String>();
    private static Map<String, String> jmxUsers = new TreeMap<String, String>();
    private static Map<String, String> jmxPasswords = new TreeMap<String, String>();
    private static Map<String, String> jmxProtocolProviderPackages = new TreeMap<String, String>();
    private static String defaultTarget = null;
    public static final String DEFAULT_URL = "service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas";
    public static final String DEFAULT_FILE = "jmxurls.properties";
    private IJMXConnectionFactory jmxFactory = null;
    protected Log logger = LogFactory.getLog(JmxAP.class);

    public JmxAP(String jmxUrl, CommandDispatcher cmdDispatcher) {
        this.jmxUrl = jmxUrl;
        if (cmdDispatcher != null) {
            this.cmdDispatcher = cmdDispatcher;
            if (this.cmdDispatcher.isEmbedded()) {
                this.connectJMX();
            }
        }
    }

    public JmxAP(CommandDispatcher cmdDispatcher) {
        this(jmxTargets.get(defaultTarget), cmdDispatcher);
    }

    public String getJmxUrl() {
        return this.jmxUrl;
    }

    private void connectJMX() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Connecting to the jmxFactory ...", new Object[0]);
        }
        try {
            ctx = new InitialContext();
        }
        catch (NamingException e) {
            this.logger.error((Object)"Error while creating initialContext : {0}. An unmanaged JMX connection will be used instead.", new Object[]{e.getMessage()});
        }
        String lookup = this.jmxUrl.replaceAll(":|/", "_");
        try {
            this.jmxFactory = (IJMXConnectionFactory)ctx.lookup(lookup);
        }
        catch (NamingException e) {
            this.logger.error((Object)"Error while looking up JMX Connection factory {0} : {1}.  An unmanaged JMX connection will be used instead. ", new Object[]{lookup, e.getMessage()});
        }
    }

    public MBeanServerConnection getMBeanServerConnection() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getting MBeanserverConnection", new Object[0]);
        }
        if (this.jmxConnection == null) {
            if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"getting MBeanserverConnection using the pool", new Object[0]);
                    }
                    this.jmxConnectionEmbedded = (IJMXConnectionServer)this.jmxFactory.getConnection((ConnectionSpec)new JMXConnectionParam(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl), jmxProtocolProviderPackages.get(this.jmxUrl)));
                    this.jmxConnection = this.jmxConnectionEmbedded;
                }
                catch (ResourceException e) {
                    this.logger.error((Object)"Error while getting a connection : {0}", new Object[]{e.getMessage()});
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Creating a simple JMX Connection without using the pool, URL {0}", new Object[]{this.jmxUrl});
                }
                this.jmxConnection = new JmxCnxWrapper(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl), jmxProtocolProviderPackages.get(this.jmxUrl));
            }
        }
        return this.jmxConnection;
    }

    public MBeanServerConnection getMBeanServerConnection(boolean usePool) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"getting MBeanserverConnection", new Object[0]);
        }
        if (this.jmxConnection == null) {
            if (usePool && this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
                try {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"getting MBeanserverConnection using the pool", new Object[0]);
                    }
                    this.jmxConnectionEmbedded = (IJMXConnectionServer)this.jmxFactory.getConnection((ConnectionSpec)new JMXConnectionParam(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl), jmxProtocolProviderPackages.get(this.jmxUrl)));
                    this.jmxConnection = this.jmxConnectionEmbedded;
                }
                catch (ResourceException e) {
                    this.logger.error((Object)"Error while getting a connection for URL {0} : {1}", new Object[]{this.jmxUrl, e.getMessage()});
                }
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Opening a simple JMX Connection without using the pool, URL {0}", new Object[]{this.jmxUrl});
                }
                this.jmxConnection = new JmxCnxWrapper(this.jmxUrl, jmxUsers.get(this.jmxUrl), jmxPasswords.get(this.jmxUrl), jmxProtocolProviderPackages.get(this.jmxUrl));
            }
        }
        return this.jmxConnection;
    }

    public void releaseMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            this.jmxConnectionEmbedded.release();
            this.jmxConnection = null;
        }
    }

    public void closeMBeanServerConnection() {
        if (this.cmdDispatcher != null && this.cmdDispatcher.isEmbedded() && this.jmxFactory != null) {
            try {
                this.jmxConnectionEmbedded.close();
                this.jmxConnectionEmbedded = null;
            }
            catch (ResourceException e) {
                e.printStackTrace();
            }
        }
    }

    private static Properties getProperties(File propertyFile) throws IOException {
        Properties properties = new Properties();
        FileInputStream in = new FileInputStream(propertyFile);
        properties.load(in);
        in.close();
        return properties;
    }

    public static String getJmxUrl(String name) {
        if (name == null) {
            return jmxTargets.get(defaultTarget);
        }
        if (name.startsWith("service:jmx:rmi")) {
            return name;
        }
        return jmxTargets.get(name);
    }

    public static String[] getJmxTargets() {
        String[] targets = null;
        if (!jmxTargets.isEmpty()) {
            targets = new String[jmxTargets.size()];
            targets = jmxTargets.keySet().toArray(targets);
        }
        return targets;
    }

    public static String[] getJmxTargets(String[] proposed) {
        int i;
        boolean all = false;
        String[] targetsArray = null;
        LinkedList<String> targetsList = new LinkedList<String>();
        if (proposed != null) {
            for (i = 0; i < proposed.length; ++i) {
                if ("all".equalsIgnoreCase(proposed[i])) {
                    all = true;
                    break;
                }
                String url = JmxAP.getJmxUrl(proposed[i]);
                if (url == null) continue;
                targetsList.add(proposed[i]);
            }
        } else if (defaultTarget != null) {
            targetsList.add(defaultTarget);
        }
        if (all) {
            targetsArray = JmxAP.getJmxTargets();
        } else if (targetsList.size() > 0) {
            targetsArray = new String[targetsList.size()];
            for (i = 0; i < targetsList.size(); ++i) {
                targetsArray[i] = (String)targetsList.get(i);
            }
        }
        return targetsArray;
    }

    public static String getDefaultTarget() {
        return defaultTarget;
    }

    private static void load() {
        Log logger = LogFactory.getLog(JmxAP.class);
        String dftTarget = null;
        String url = System.getProperty("jasmine.jmx.url");
        String user = System.getProperty("jasmine.jmx.user");
        String password = System.getProperty("jasmine.jmx.password");
        String filename = System.getProperty("jasmine.jmx.file");
        if (filename == null) {
            filename = DEFAULT_FILE;
        }
        String name = null;
        if (url != null) {
            name = "jonas";
            if (url.matches(".*connector_.*")) {
                int ix = url.lastIndexOf("connector_");
                name = url.substring(ix + "connector_".length());
            }
            jmxTargets.put(name, url);
            if (user != null && password != null) {
                jmxUsers.put(url, user);
                jmxPasswords.put(url, password);
            }
            defaultTarget = name;
        }
        Properties props = null;
        try {
            props = JmxAP.getProperties(new File(filename));
        }
        catch (IOException e) {
            try {
                Class.forName("org.ow2.jonas.lib.bootstrap.JProp");
                props = JmxAP.getProperties(new File(org.ow2.jonas.lib.bootstrap.JProp.getConfDir(), filename));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"class loaded : org.ow2.jonas.lib.bootstrap.JProp", new Object[0]);
                }
            }
            catch (Exception e3) {
                try {
                    Class.forName("org.objectweb.jonas.common.JProp");
                    props = JmxAP.getProperties(new File(JProp.getConfDir(), filename));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"class loaded : org.objectweb.jonas.common.JProp", new Object[0]);
                    }
                }
                catch (Exception e1) {
                    logger.warn((Object)"Cannot read default JMX configuration file {0} : {1}", new Object[]{filename, e1.getMessage(), e1});
                }
            }
        }
        if (props != null && props.size() != 0) {
            String key;
            Enumeration<?> en = props.propertyNames();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (!key.startsWith("jasmine.jmx.url.")) continue;
                name = key.substring("jasmine.jmx.url.".length());
                url = props.getProperty(key);
                jmxTargets.put(name, url);
            }
            en = props.propertyNames();
            while (en.hasMoreElements()) {
                key = (String)en.nextElement();
                if (key.startsWith("jasmine.jmx.user.")) {
                    name = key.substring("jasmine.jmx.user.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set user for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxUsers.put(url, props.getProperty(key));
                    continue;
                }
                if (key.startsWith("jasmine.jmx.password.")) {
                    name = key.substring("jasmine.jmx.password.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set password for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxPasswords.put(url, props.getProperty(key));
                    continue;
                }
                if (key.startsWith("jasmine.jmx.protocol.providers.")) {
                    name = key.substring("jasmine.jmx.protocol.providers.".length());
                    url = jmxTargets.get(name);
                    if (url == null) {
                        logger.warn((Object)"Cannot set protocol providers for target {0}", new Object[]{name});
                        continue;
                    }
                    jmxProtocolProviderPackages.put(url, props.getProperty(key));
                    continue;
                }
                if (!"jasmine.jmx.default.target".equals(key) || defaultTarget != null) continue;
                dftTarget = props.getProperty(key);
            }
        }
        if (defaultTarget == null) {
            if (dftTarget != null) {
                if (jmxTargets.get(dftTarget) != null) {
                    defaultTarget = dftTarget;
                } else {
                    logger.warn((Object)"jasmine.jmx.default.target property specifies an invalid default target {0}. No default target set.", new Object[]{dftTarget});
                }
            } else {
                defaultTarget = "jonas";
                jmxTargets.put(defaultTarget, DEFAULT_URL);
                logger.warn((Object)"jasmine.jmx.default.target property not set. Setting default target to: {0}; setting jmxUrl to {1}.", new Object[]{defaultTarget, DEFAULT_URL});
            }
        }
    }

    static {
        JmxAP.load();
    }
}

