/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.util.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationResourceBundle {
    public static final String DEFAULT_KEY = "DEFAULT";
    private final String baseName;
    private final Map<String, String> displayNames;
    private final Map<String, String> descriptions;
    private volatile Map<Locale, ResourceBundle> resources;

    public ApplicationResourceBundle(String baseName, Map<String, String> displayNames, Map<String, String> descriptions) {
        if (baseName == null) {
            throw new IllegalArgumentException();
        }
        this.baseName = baseName;
        this.displayNames = displayNames;
        this.descriptions = descriptions;
        this.resources = new HashMap(4, 1.0f);
    }

    public String getBaseName() {
        return this.baseName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle bundle;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((bundle = (ResourceBundle)this.resources.get((Object)locale)) == null) {
            ClassLoader loader = Util.getCurrentLoader(this);
            ApplicationResourceBundle applicationResourceBundle = this;
            synchronized (applicationResourceBundle) {
                bundle = (ResourceBundle)this.resources.get((Object)locale);
                if (bundle == null) {
                    bundle = ResourceBundle.getBundle(this.baseName, locale, loader);
                    this.resources.put((Object)locale, (Object)bundle);
                }
            }
        }
        return bundle;
    }

    public String getDisplayName(Locale locale) {
        String displayName = null;
        if (this.displayNames != null) {
            displayName = this.queryMap(locale, this.displayNames);
        }
        return displayName != null ? displayName : "";
    }

    public String getDescription(Locale locale) {
        String description = null;
        if (this.descriptions != null) {
            description = this.queryMap(locale, this.descriptions);
        }
        return description != null ? description : "";
    }

    private String queryMap(Locale locale, Map<String, String> map) {
        if (locale == null) {
            return (String)map.get((Object)DEFAULT_KEY);
        }
        String key = locale.toString();
        String description = (String)map.get((Object)key);
        if (description == null) {
            return (String)map.get((Object)DEFAULT_KEY);
        }
        return null;
    }
}

