/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el;

import com.sun.faces.util.MessageUtils;
import java.lang.reflect.Array;
import java.util.List;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;

public class PropertyResolverImpl
extends PropertyResolver {
    private PropertyResolver delegate;

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        PropertyResolverImpl.assertInput(base, index);
        if (this.delegate != null) {
            return this.delegate.getType(base, index);
        }
        Class type = base.getClass();
        try {
            if (type.isArray()) {
                Array.get(base, index);
                return type.getComponentType();
            }
            if (base instanceof List) {
                Object value = ((List)base).get(index);
                return value != null ? value.getClass() : null;
            }
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", base));
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", base, index, Array.getLength(base)));
        }
        catch (IndexOutOfBoundsException ioobe) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", base, index, ((List)base).size()));
        }
    }

    public Class getType(Object base, Object property) {
        PropertyResolverImpl.assertInput(base, property);
        if (this.delegate != null) {
            return this.delegate.getType(base, property);
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return context.getApplication().getELResolver().getType(context.getELContext(), base, property);
        }
        catch (javax.el.PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(pnfe);
        }
        catch (ELException elex) {
            throw new EvaluationException(elex);
        }
    }

    public Object getValue(Object base, int index) {
        if (base == null) {
            return null;
        }
        if (this.delegate != null) {
            return this.delegate.getValue(base, index);
        }
        if (base.getClass().isArray()) {
            try {
                return Array.get(base, index);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return null;
            }
        }
        if (base instanceof List) {
            try {
                return ((List)base).get(index);
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
        }
        throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", base));
    }

    public Object getValue(Object base, Object property) {
        if (this.delegate != null) {
            return this.delegate.getValue(base, property);
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return context.getApplication().getELResolver().getValue(context.getELContext(), base, property);
        }
        catch (javax.el.PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(pnfe);
        }
        catch (ELException elex) {
            throw new EvaluationException(elex);
        }
    }

    public boolean isReadOnly(Object base, int index) {
        PropertyResolverImpl.assertInput(base, index);
        if (this.delegate != null) {
            return this.delegate.isReadOnly(base, index);
        }
        if (base instanceof List || base.getClass().isArray()) {
            return false;
        }
        throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", base));
    }

    public boolean isReadOnly(Object base, Object property) {
        if (this.delegate != null) {
            return this.delegate.isReadOnly(base, property);
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            return context.getApplication().getELResolver().isReadOnly(context.getELContext(), base, property);
        }
        catch (ELException elex) {
            throw new EvaluationException(elex);
        }
    }

    public void setValue(Object base, int index, Object value) {
        PropertyResolverImpl.assertInput(base, index);
        if (this.delegate != null) {
            this.delegate.setValue(base, index, value);
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Class type = base.getClass();
        if (type.isArray()) {
            try {
                Array.set(base, index, context.getApplication().getExpressionFactory().coerceToType(value, type.getComponentType()));
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", base, index, Array.getLength(base)));
            }
        } else if (base instanceof List) {
            try {
                ((List)base).set(index, value);
            }
            catch (IndexOutOfBoundsException ioobe) {
                throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.SIZE_OUT_OF_BOUNDS_ERROR", base, index, ((List)base).size()));
            }
        } else {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.PROPERTY_TYPE_ERROR", base));
        }
    }

    public void setValue(Object base, Object property, Object value) {
        if (this.delegate != null) {
            this.delegate.setValue(base, property, value);
            return;
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            context.getApplication().getELResolver().setValue(context.getELContext(), base, property, value);
        }
        catch (javax.el.PropertyNotFoundException pnfe) {
            throw new PropertyNotFoundException(pnfe);
        }
        catch (PropertyNotWritableException pnwe) {
            throw new PropertyNotFoundException(pnwe);
        }
        catch (ELException elex) {
            throw new EvaluationException(elex);
        }
    }

    public void setDelegate(PropertyResolver delegate) {
        this.delegate = delegate;
    }

    protected static void assertInput(Object base, Object property) throws PropertyNotFoundException {
        if (base == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base");
            throw new PropertyNotFoundException(message);
        }
        if (property == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "property");
            throw new PropertyNotFoundException(message);
        }
    }

    protected static void assertInput(Object base, int index) throws PropertyNotFoundException {
        if (base == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "base");
            throw new PropertyNotFoundException(message);
        }
        if (index < 0) {
            throw new PropertyNotFoundException(MessageUtils.getExceptionMessageString("com.sun.faces.OUT_OF_BOUNDS_ERROR", base, index));
        }
    }
}

