/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtils {
    private static final Map<ClassLoader, ConcurrentMap<String, MetaData>> REFLECTION_CACHE = new WeakHashMap();

    private ReflectionUtils() {
    }

    public static synchronized void clearCache(ClassLoader loader) {
        REFLECTION_CACHE.remove((Object)loader);
    }

    public static synchronized void initCache(ClassLoader loader) {
        if (REFLECTION_CACHE.get((Object)loader) == null) {
            REFLECTION_CACHE.put((Object)loader, new ConcurrentHashMap());
        }
    }

    public static Constructor lookupConstructor(Class<?> clazz, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupConstructor(params);
    }

    public static Method lookupMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        ClassLoader loader = Util.getCurrentLoader(clazz);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, clazz).lookupMethod(methodName, params);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass().newInstance();
    }

    public static Class<?> lookupClass(String className) {
        ClassLoader loader = Util.getCurrentLoader(null);
        if (loader == null) {
            return null;
        }
        return ReflectionUtils.getMetaData(loader, className).lookupClass();
    }

    private static MetaData getMetaData(ClassLoader loader, Class<?> clazz) {
        MetaData meta;
        ConcurrentMap cache = (ConcurrentMap)REFLECTION_CACHE.get((Object)loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = (ConcurrentMap)REFLECTION_CACHE.get((Object)loader);
        }
        if ((meta = (MetaData)cache.get(clazz.getName())) == null) {
            meta = new MetaData(clazz);
            cache.put(clazz.getName(), meta);
        }
        return meta;
    }

    private static MetaData getMetaData(ClassLoader loader, String className) {
        MetaData meta;
        ConcurrentMap cache = (ConcurrentMap)REFLECTION_CACHE.get((Object)loader);
        if (cache == null) {
            ReflectionUtils.initCache(loader);
            cache = (ConcurrentMap)REFLECTION_CACHE.get((Object)loader);
        }
        if ((meta = (MetaData)cache.get(className)) == null) {
            try {
                Class clazz = Util.loadClass(className, cache);
                meta = new MetaData(clazz);
                cache.put(className, meta);
            }
            catch (ClassNotFoundException cnfe) {
                return null;
            }
        }
        return meta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MetaData {
        Map<Integer, Constructor> constructors;
        Map<String, HashMap<Integer, Method>> methods;
        Map<String, HashMap<Integer, Method>> declaredMethods;
        Class<?> clazz;

        public MetaData(Class<?> clazz) {
            int i;
            String name = null;
            this.clazz = clazz;
            Constructor[] ctors = clazz.getConstructors();
            this.constructors = new HashMap(ctors.length, 1.0f);
            int len = ctors.length;
            for (int i2 = 0; i2 < len; ++i2) {
                this.constructors.put((Object)MetaData.getKey(ctors[i2].getParameterTypes()), (Object)ctors[i2]);
            }
            Method[] meths = clazz.getMethods();
            this.methods = new HashMap(meths.length, 1.0f);
            int len2 = meths.length;
            for (i = 0; i < len2; ++i) {
                name = meths[i].getName();
                HashMap methodsMap = (HashMap)this.methods.get((Object)name);
                if (methodsMap == null) {
                    methodsMap = new HashMap(4, 1.0f);
                    this.methods.put((Object)name, (Object)methodsMap);
                }
                methodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
            }
            meths = clazz.getDeclaredMethods();
            this.declaredMethods = new HashMap(meths.length, 1.0f);
            len2 = meths.length;
            for (i = 0; i < len2; ++i) {
                name = meths[i].getName();
                HashMap declaredMethodsMap = (HashMap)this.declaredMethods.get((Object)name);
                if (declaredMethodsMap == null) {
                    declaredMethodsMap = new HashMap(4, 1.0f);
                    this.declaredMethods.put((Object)name, (Object)declaredMethodsMap);
                }
                declaredMethodsMap.put(MetaData.getKey(meths[i].getParameterTypes()), meths[i]);
            }
        }

        public Constructor lookupConstructor(Class<?> ... params) {
            return (Constructor)this.constructors.get((Object)MetaData.getKey(params));
        }

        public Method lookupMethod(String name, Class<?> ... params) {
            Map map = (Map)this.methods.get((Object)name);
            Integer key = MetaData.getKey(params);
            Method result = null;
            if ((null == map || null == (result = (Method)map.get(key))) && null != (map = (Map)this.declaredMethods.get((Object)name))) {
                result = (Method)map.get(key);
            }
            return result;
        }

        public Class<?> lookupClass() {
            return this.clazz;
        }

        private static Integer getKey(Class<?> ... params) {
            return Arrays.deepHashCode((Object[])params);
        }
    }
}

