/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeOperationsException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private static final long serialVersionUID = 4611072955724144607L;
    private String typeName;
    private Map roleName2InfoMap = new HashMap();
    private boolean isInRelationService;

    public RelationTypeSupport(String relationTypeName, RoleInfo[] roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationTypeName == null || roleInfo == null) {
            throw new IllegalArgumentException("Illegal Null Value");
        }
        this.typeName = relationTypeName;
        RelationTypeSupport.checkRoleInfos(roleInfo);
        this.addRoleInfos(roleInfo);
    }

    protected RelationTypeSupport(String relationTypeName) {
        if (relationTypeName == null) {
            throw new IllegalArgumentException("Null RelationType Name");
        }
        this.typeName = relationTypeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoleInfos(RoleInfo[] roleInfos) throws IllegalArgumentException {
        if (roleInfos == null) {
            throw new IllegalArgumentException("Null RoleInfo[]");
        }
        Map map = this.roleName2InfoMap;
        synchronized (map) {
            for (int i = 0; i < roleInfos.length; ++i) {
                RoleInfo currentRoleInfo = roleInfos[i];
                this.addRoleNameToRoleInfo(currentRoleInfo.getName(), currentRoleInfo);
            }
        }
    }

    public String getRelationTypeName() {
        return this.typeName;
    }

    public RoleInfo getRoleInfo(String roleInfoName) throws RoleInfoNotFoundException, IllegalArgumentException {
        if (roleInfoName == null) {
            throw new IllegalArgumentException("roleInfo Name cannot have a null value");
        }
        RoleInfo roleInfo = (RoleInfo)this.roleName2InfoMap.get(roleInfoName);
        if (roleInfo == null) {
            throw new RoleInfoNotFoundException("No role info for role named " + roleInfoName);
        }
        return roleInfo;
    }

    public List getRoleInfos() {
        return new ArrayList(this.roleName2InfoMap.values());
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            throw new IllegalArgumentException("Cannot add a null roleInfo in the relation service");
        }
        if (this.isInRelationService) {
            throw new RuntimeOperationsException(null, "RoleInfo cannot be added as the relation type is already declared in the relation service");
        }
        String roleName = roleInfo.getName();
        if (this.roleName2InfoMap.containsKey(roleName)) {
            throw new InvalidRelationTypeException("Already a roleInfo declared for roleName " + roleName);
        }
        this.addRoleNameToRoleInfo(roleName, roleInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRoleNameToRoleInfo(String roleName, RoleInfo roleInfo) {
        Map map = this.roleName2InfoMap;
        synchronized (map) {
            this.roleName2InfoMap.put(roleName, roleInfo);
        }
    }

    static void checkRoleInfos(RoleInfo[] roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            throw new IllegalArgumentException("RoleInfo is null.");
        }
        if (roleInfo.length == 0) {
            throw new InvalidRelationTypeException("RoleInfo is empty");
        }
        ArrayList roleNameList = new ArrayList();
        for (int i = 0; i < roleInfo.length; ++i) {
            RoleInfo currentRoleInfo = roleInfo[i];
            if (currentRoleInfo == null) {
                throw new InvalidRelationTypeException("Null roleInfo");
            }
            String roleName = currentRoleInfo.getName();
            if (roleNameList.contains(roleName)) {
                throw new InvalidRelationTypeException("Two RoleInfos provided for role " + roleName);
            }
            roleNameList.add(roleName);
        }
    }

    void setRelationServiceFlag(boolean value) {
        this.isInRelationService = value;
    }
}

