/*
 * Decompiled with CFR 0.152.
 */
package javax.resource.spi.security;

import java.io.Serializable;
import java.util.Arrays;
import javax.resource.spi.ManagedConnectionFactory;

public final class PasswordCredential
implements Serializable {
    private static final long serialVersionUID = -1770833344350711674L;
    private String userName;
    private char[] password;
    private ManagedConnectionFactory managedConnectionFactory;

    public PasswordCredential(String userName, char[] password) {
        this.userName = userName;
        this.password = (char[])password.clone();
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.password;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this.managedConnectionFactory = mcf;
    }

    public boolean equals(Object other) {
        if (!(other instanceof PasswordCredential)) {
            return false;
        }
        PasswordCredential credential = (PasswordCredential)other;
        if (!this.userName.equals(credential.userName)) {
            return false;
        }
        return Arrays.equals(this.password, credential.password);
    }

    public int hashCode() {
        return this.userName.hashCode() + Arrays.hashCode((char[])this.password);
    }
}

