/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.LogLevel;
import org.apache.tools.ant.util.FileUtils;

public class Echo
extends Task {
    protected String message = "";
    protected File file = null;
    protected boolean append = false;
    private String encoding = "";
    protected int logLevel = 1;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        if (this.file == null) {
            this.log(this.message, this.logLevel);
            return;
        }
        Writer out = null;
        try {
            try {
                String filename = this.file.getAbsolutePath();
                out = this.encoding == null || this.encoding.length() == 0 ? new FileWriter(filename, this.append) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename, this.append), this.encoding));
                ((Writer)out).write(this.message, 0, this.message.length());
            }
            catch (IOException ioe) {
                throw new BuildException(ioe, this.getLocation());
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            FileUtils.close(out);
            throw throwable;
        }
        FileUtils.close(out);
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void addText(String msg) {
        this.message = this.message + this.getProject().replaceProperties(msg);
    }

    public void setLevel(EchoLevel echoLevel) {
        this.logLevel = echoLevel.getLevel();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public static class EchoLevel
    extends LogLevel {
    }
}

