/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.util.loader;

public final class ClassUtils {
    private ClassUtils() {
    }

    public static Class forName(String className) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Class cls = null;
        try {
            cls = Class.forName(className, true, tccl);
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader current = ClassUtils.class.getClassLoader();
            cls = Class.forName(className, true, current);
        }
        return cls;
    }

    public static Class forName(String className, Class clazz) throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        Class cls = null;
        try {
            cls = Class.forName(className, true, tccl);
        }
        catch (ClassNotFoundException cnfe) {
            ClassLoader current = clazz.getClassLoader();
            if (current != null) {
                try {
                    cls = Class.forName(className, true, current);
                }
                catch (ClassNotFoundException cnfe2) {
                    throw new ClassNotFoundException("Class Not found in current ThreadClassLoader '" + tccl + "' and in '" + current + "' classloaders.", cnfe2);
                }
            }
            throw cnfe;
        }
        return cls;
    }
}

