/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.clusterd.xml;

import org.ow2.jonas.deployment.clusterd.ClusterDaemonSchemas;
import org.ow2.jonas.deployment.clusterd.xml.Discovery;
import org.ow2.jonas.deployment.clusterd.xml.Server;
import org.ow2.jonas.deployment.common.CommonsSchemas;
import org.ow2.jonas.deployment.common.xml.AbsDescriptionElement;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.common.xml.TopLevelElement;

public class ClusterDaemon
extends AbsDescriptionElement
implements TopLevelElement {
    private static final long serialVersionUID = 3212755715938568244L;
    private String name = null;
    private String domainName = null;
    private String jonasInteractionMode = null;
    private JLinkedList serverList = new JLinkedList("server");
    private Discovery discovery = null;
    private boolean jmxSecured = false;
    private String jmxAuthenticationMethod = null;
    private String jmxAuthenticationParameter = null;
    private String jmxAuthorizationMethod = null;
    private String jmxAuthorizationParameter = null;
    private static final String header = CommonsSchemas.getHeaderForElement("cluster-daemon", ClusterDaemonSchemas.getLastSchema());

    public void addServer(Server server) {
        this.serverList.add(server);
    }

    public JLinkedList getServerList() {
        return this.serverList;
    }

    public void setServerList(JLinkedList serverList) {
        this.serverList = serverList;
    }

    public String toXML(int indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.indent(indent));
        sb.append(header);
        indent += 2;
        if (this.getName() != null) {
            sb.append(this.xmlElement(this.getName(), "name", indent));
        }
        if (this.getDomainName() != null) {
            sb.append(this.xmlElement(this.getDomainName(), "domain-name", indent));
        }
        if (this.getJonasInteractionMode() != null) {
            sb.append(this.xmlElement(this.getJonasInteractionMode(), "jonas-interaction-mode", indent));
        }
        sb.append(this.xmlElement(this.getJmxSecured(), "jmx.secured", indent));
        sb.append(this.xmlElement(this.getJmxAuthenticationMethod(), "jmx.authentication.method", indent));
        sb.append(this.xmlElement(this.getJmxAuthenticationParameter(), "jmx.authentication.parameter", indent));
        sb.append(this.xmlElement(this.getJmxAuthorizationMethod(), "jmx.authorization.method", indent));
        sb.append(this.xmlElement(this.getJmxAuthorizationParameter(), "jmx.authorization.parameter", indent));
        if (this.discovery != null) {
            sb.append(this.discovery.toXML(indent));
        }
        sb.append(this.getServerList().toXML(indent));
        sb.append(this.indent(indent -= 2));
        sb.append("</cluster-daemon>\n");
        return sb.toString();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJonasInteractionMode() {
        return this.jonasInteractionMode;
    }

    public void setJonasInteractionMode(String jonasInteractionMode) {
        this.jonasInteractionMode = jonasInteractionMode;
    }

    public String getDiscoveryStackFile() {
        return this.discovery.getDiscoveryStackFile();
    }

    public void setDiscoveryStackFile(String discoveryStackFile) {
        this.discovery.setDiscoveryStackFile(discoveryStackFile);
    }

    public String getDiscoveryGroupName() {
        return this.discovery.getDiscoveryGroupName();
    }

    public void setDiscoveryGroupName(String discoveryGroupName) {
        this.discovery.setDiscoveryGroupName(discoveryGroupName);
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }

    public void setDiscovery(Discovery discovery) {
        this.discovery = discovery;
    }

    public boolean isJmxSecured() {
        return this.jmxSecured;
    }

    public String getJmxSecured() {
        return Boolean.toString((boolean)this.jmxSecured);
    }

    public void setJmxSecured(boolean jmxSecured) {
        this.jmxSecured = jmxSecured;
    }

    public void setJmxSecured(String jmxSecured) {
        this.jmxSecured = "true".equalsIgnoreCase(jmxSecured);
    }

    public String getJmxAuthenticationMethod() {
        return this.jmxAuthenticationMethod;
    }

    public void setJmxAuthenticationMethod(String jmxAuthenticationMethod) {
        this.jmxAuthenticationMethod = jmxAuthenticationMethod;
    }

    public String getJmxAuthenticationParameter() {
        return this.jmxAuthenticationParameter;
    }

    public void setJmxAuthenticationParameter(String jmxAuthenticationParameter) {
        this.jmxAuthenticationParameter = jmxAuthenticationParameter;
    }

    public String getJmxAuthorizationMethod() {
        return this.jmxAuthorizationMethod;
    }

    public void setJmxAuthorizationMethod(String jmxAuthorizationMethod) {
        this.jmxAuthorizationMethod = jmxAuthorizationMethod;
    }

    public String getJmxAuthorizationParameter() {
        return this.jmxAuthorizationParameter;
    }

    public void setJmxAuthorizationParameter(String jmxAuthorizationParameter) {
        this.jmxAuthorizationParameter = jmxAuthorizationParameter;
    }
}

